<?php

// Get the verification token from the URL
include "db_connect.php";
$token = $_GET['token'];

if (!$token) {
    echo 'Invalid token';
    exit();
}

// Check if the token exists and update the user status
$query = "SELECT email FROM signup WHERE temp_token= ? AND status = 'pending'";
$stmt = $db_connect->prepare($query);
$stmt->bind_param('s', $token);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    // Token is valid, update the user's status to verified
    $updateQuery = "UPDATE signup SET status = 'verified' WHERE temp_token = ?";
    $updateStmt = $db_connect->prepare($updateQuery);
    $updateStmt->bind_param('s', $token);
    $updateStmt->execute();

    // Redirect to login page
    header("Location: https://www.ukraftstore.com/lander?verified=true");
    exit();
} else {
    echo 'Invalid or expired token';
}