<?php
include "db_connect.php";  // Database connection

$data = json_decode(file_get_contents('php://input'), true);

// Check if the email and verification code are provided
if (isset($data['email']) && isset($data['code'])) {
    $email = mysqli_real_escape_string($db_connect, $data['email']);
    $verification_code = mysqli_real_escape_string($db_connect, $data['code']);

    // Query to get the verification code from the database
    $query = "SELECT verification_code, temp_token_validation, id, token, name, email FROM signup WHERE email = '$email' LIMIT 1";
    $result = mysqli_query($db_connect, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $stored_code = $row['verification_code'];
        $expiry = $row['temp_token_validation'];
        $status = 'verified';

        // Check if the code matches and has not expired
        if ($stored_code === $verification_code) {
            if (strtotime($expiry) > time()) {
                // Code is valid, proceed to verify the user
                $update_query = "UPDATE signup SET status = '$status', verification_code = NULL, temp_token_validation = NULL WHERE email = '$email'";

                if (mysqli_query($db_connect, $update_query)) {
                    echo json_encode([
                        'status' => 200,
                        'success' => true,
                        'message' => 'Verification successful!',
                        'userinfo' => [
                            'token' => $row['token'],
                            'user' => [
                                'userId' => $row['id'],
                                'name' => $row['name'],
                                'email' => $row['email'],
                            ]
                        ]
                    ], JSON_PRETTY_PRINT);
                } else {
                    echo json_encode([
                        'status' => 500,
                        'error' => true,
                        'message' => 'Failed to update the verification status'
                    ], JSON_PRETTY_PRINT);
                }
            } else {
                // Code has expired
                echo json_encode([
                    'status' => 400,
                    'error' => true,
                    'message' => 'Verification code has expired. Please request a new one.'
                ], JSON_PRETTY_PRINT);
            }
        } else {
            // Code does not match
            echo json_encode([
                'status' => 400,
                'error' => true,
                'message' => 'Invalid verification code.'
            ], JSON_PRETTY_PRINT);
        }
    } else {
        // Email not found in the database
        echo json_encode([
            'status' => 404,
            'error' => true,
            'message' => 'User not found.'
        ], JSON_PRETTY_PRINT);
    }
} else {
    // Email or verification code missing from request
    echo json_encode([
        'status' => 400,
        'error' => true,
        'message' => 'Email and verification code are required.'
    ], JSON_PRETTY_PRINT);
}
