<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();

$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
    case 'GET':

        if (isset($token)) {
            $stmt = $db_connect->prepare("SELECT token, id FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                $get_id = $userRow['id'];

                $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";
$baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";
$limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? intval($_GET['limit']) : 10; // Default to 10
$offset = isset($_GET['offset']) && is_numeric($_GET['offset']) ? intval($_GET['offset']) : 0;
$user_id = isset($_GET['user_id']) && is_numeric($_GET['user_id']) ? intval($_GET['user_id']) : null;

if ($user_id && $limit && $offset >= 0) {
    $sql = "SELECT 
            orders.id,
            orders.status,
            orders.created_at,
            orders.total_amount,
            COUNT(order_items.order_id) AS total_products
        FROM orders
        INNER JOIN order_items ON order_items.order_id = orders.id
        WHERE orders.signup_id = ?
        GROUP BY orders.id, orders.status, orders.created_at, orders.total_amount
        ORDER BY orders.created_at ASC
        LIMIT ? OFFSET ?
    ";

    $stmt = $db_connect->prepare($sql);
    $stmt->bind_param("iii", $user_id, $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $orderData = [];
        while ($item = $result->fetch_assoc()) {
            $orderData[] = $item;
        }

        echo json_encode([
            'status' => 200,
            'success' => true,
            'offset_page' => $offset,
            'limit_per_page' => $limit,
            'message' => $orderData
        ], JSON_PRETTY_PRINT);
    } else {
        echo json_encode([
            'status' => 400,
            'error' => true,
            'message' => 'No order found.'
        ], JSON_PRETTY_PRINT);
    }
} else {
    echo json_encode([
        'status' => 400,
        'error' => true,
        'message' => 'Invalid user id or parameters.'
    ], JSON_PRETTY_PRINT);
}


            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode(
            [
                'status' => 405,
                'error' => true,
                'message' => 'Method not allowed.'
            ],
            JSON_PRETTY_PRINT
        );
}
