<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();

$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
    case 'POST':

        if (isset($token)) {
            $stmt = $db_connect->prepare("SELECT token, id, email FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                $get_id = $userRow['id'];
$get_email = $userRow['email'];

                $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";
                // $path = explode('/', $_SERVER["REQUEST_URI"]);
                $data = json_decode(file_get_contents("php://input"), true);

                $order_id = $data['order_id'];
                $email = $data['email'];
                if ($token === $get_token) {
                    if ($order_id && $email ===$get_email) {
                        $orderData = [];

                        // Get order details
                        $sql = "SELECT 
                        orders.id,
                        orders.status,
                        orders.created_at,
                        orders.total_amount,
                        orders.order_progress,
                        COUNT(order_items.order_id) AS total_products
                        FROM orders
                        INNER JOIN order_items ON order_items.order_id = orders.id
                        WHERE orders.id = ?
                        ";
                        $stmt = $db_connect->prepare($sql);
                        $stmt->bind_param("i", $order_id);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        if ($result->num_rows > 0) {
                            $orderData = $result->fetch_assoc();
                            $orderData['items'] = [];
                            // Define the base URL for images
                            $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";

                            // Order individual items for order details
                            $query = "SELECT order_items.order_id, order_items.product_id, 
                order_items.quantity AS orders_quantity,
                order_items.price AS order_price,
                order_items.created_at AS order_item_time,
                products.name AS product_name,
                products.description AS product_description,
                products.price AS product_price,
                product_images.image_url AS product_image
                FROM order_items
                LEFT JOIN products ON order_items.product_id = products.id
                LEFT JOIN product_images ON product_images.product_id = products.id AND product_images.is_primary = 1
                WHERE order_items.order_id = ?";

                            $stmt = $db_connect->prepare($query);
                            $stmt->bind_param("i", $order_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($item = $result->fetch_assoc()) {
                                // Combine base URL with image filename to create full image URL
                                $item['product_image'] = $item['product_image'] ? $baseURL . $item['product_image'] : null;
                                $orderData['items'][] = $item;
                            }

                            echo json_encode([
                                'status' => 200,
                                'success' => true,
                                'message' => $orderData
                            ], JSON_PRETTY_PRINT);
                        } else {
                            echo json_encode([
                                'status' => 400,
                                'error' => true,
                                'message' => 'No order found.'
                            ], JSON_PRETTY_PRINT);
                        }
                    } else {
                        echo json_encode([
                            'status' => 400,
                            'error' => true,
                            'message' => 'Invalid order id or email address.'
                        ], JSON_PRETTY_PRINT);
                    }
                } else {
                    // Invalid token
                    http_response_code(401);
                    echo json_encode(
                        [
                            'status' => 401,
                            'error' => true,
                            'message' => 'Mismatch token'
                        ],
                        JSON_PRETTY_PRINT
                    );
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode(
            [
                'status' => 405,
                'error' => true,
                'message' => 'Method not allowed.'
            ],
            JSON_PRETTY_PRINT
        );
}
