<?php
include "db_connect.php";
require __DIR__ . '/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

if (strtoupper($_SERVER['REQUEST_METHOD']) != 'POST') {
    file_put_contents('webhook_errors.txt', "Invalid request method\n", FILE_APPEND);
    exit();
}

if (!array_key_exists('HTTP_X_SQUAD_ENCRYPTED_BODY', $_SERVER)) {
    file_put_contents('webhook_errors.txt', "Signature header missing\n", FILE_APPEND);
    exit();
}

$input = file_get_contents("php://input");
$secretKey = $_ENV['SQUAD_SECRET_KEY'];
$expectedSignature = strtoupper(hash_hmac('sha512', $input, $secretKey));

if ($_SERVER['HTTP_X_SQUAD_ENCRYPTED_BODY'] !== $expectedSignature) {
    file_put_contents('webhook_errors.txt', "Signature mismatch\n", FILE_APPEND);
    exit();
}

$body = json_decode($input, true);
if (!$body) {
    file_put_contents('webhook_errors.txt', "Invalid JSON payload\n", FILE_APPEND);
    exit();
}

if (isset($body['Event']) && $body['Event'] == 'charge_successful' && $body['Body']['transaction_status'] == 'Success') {
    $status = $body['Body']['transaction_status'];
    $amount = $body['Body']['amount'] / 100;
    $transactionRef = $body['Body']['transaction_ref'];
    $currency = $body['Body']['currency'];
    $email = $body['Body']['email'];
    $date = $body['Body']['created_at'];
    $transactionType = $body['Body']['transaction_type'];
    $message = $body['Event'];
    $items = $body['Body']['meta']['items'];
    $orderId = $items[0]['order_id'];

    if (!$transactionRef || !$orderId || !$status || !$amount || !$currency || !$message || !$transactionType || !$items) {
        file_put_contents('error_log.txt', "Missing required data in payload\n", FILE_APPEND);
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Missing required data']);
        exit;
    }

    $checkQuery = "SELECT COUNT(*) AS count FROM transactions WHERE transaction_reference = '$transactionRef'";
    $checkResult = mysqli_query($db_connect, $checkQuery);

    if (!$checkResult) {
        file_put_contents('error_log.txt', "Error checking duplicate transaction: " . mysqli_error($db_connect) . "\n", FILE_APPEND);
        exit;
    }

    $row = mysqli_fetch_assoc($checkResult);
    if ($row['count'] > 0) {
        file_put_contents('error_log.txt', "Duplicate transaction detected: $transactionRef\n", FILE_APPEND);
        http_response_code(200);
        echo json_encode(['status' => 'info', 'message' => 'Duplicate transaction, ignored']);
        exit;
    }

    $insertQuery = "
    INSERT INTO transactions (transaction_reference, transaction_type, order_id, status, amount, currency, squadco_message) 
    VALUES ('$transactionRef', '$transactionType', '$orderId', '$status', $amount, '$currency', '$message')";

    if (!mysqli_query($db_connect, $insertQuery)) {
        file_put_contents('error_log.txt', "Error inserting into transactions: " . mysqli_error($db_connect) . "\n", FILE_APPEND);
        exit;
    }

    $updateOrderQuery = "UPDATE orders SET status = 'Complete', order_progress = 'Order placed' WHERE id = $orderId";

    if (!mysqli_query($db_connect, $updateOrderQuery)) {
        file_put_contents('error_log.txt', "Error updating orders: " . mysqli_error($db_connect) . "\n", FILE_APPEND);
        exit;
    }

    $updateItemsQuery = "UPDATE order_items SET status = 'verified' WHERE order_id = $orderId";

    if (!mysqli_query($db_connect, $updateItemsQuery)) {
        file_put_contents('error_log.txt', "Error updating order_items: " . mysqli_error($db_connect) . "\n", FILE_APPEND);
        exit;
    }

    // Send Email Notification
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->SMTPDebug = 0;                      // Enable verbose debug output
        $mail->isSMTP();                                            // Send using SMTP
        $mail->Host       = 'ukraftstoreapi.online';                       // Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
        $mail->Username   = 'info@ukraftstoreapi.online';        // SMTP username
        $mail->Password   = '#2244Frixz';                     // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            // Enable implicit TLS encryption
        $mail->Port       = 465;                                    // TCP port to connect to

        // Recipients
        $mail->setFrom('info@ukraftstore.com', 'info@ukraftstore.com');
        $mail->addAddress($email);

        $mail->isHTML(true);
        $mail->Subject = "Ukraftstore - Payment Successful - Order $orderId";
       
        $itemDetails = '';
        foreach ($items as $item) {
            $itemDetails .=
                "<li>Product: {$item['name']} - Quantity: {$item['quantity']} - Price: {$item['price']} $currency</li>";
        }

        $formattedAmount = number_format($amount, 2); // Format the amount

        $originalDate = $date; // Example: 2025-01-27T10:15:00Z
        $formattedDate = date('F j, Y, g:i A', strtotime($originalDate)); // Example: January 27, 2025, 10:15 AM

        $mail->Body = "
        <h1>Payment Successful</h1>
        <p>Dear Customer,</p>
        <p>Your payment of <strong>{$currency} {$formattedAmount}</strong> has been successfully received for Order $orderId.</p>
        <p>Thank you for your purchase! Here are your order details:</p>
        <p>Order ID: $orderId</p>
        <ul>$itemDetails</ul>
        <p>Transaction Reference: $transactionRef</p>
        <p>Date of Order:  $formattedDate</p>
        <p>Thank you for shopping with us!</p>
        <p>If you have any questions, feel free to contact us.</p>
       <p>Best regards,<br>Ukraftstore</p>";

        $mail->send();
        file_put_contents('email_log.txt', "Email sent successfully to $email for Order $orderId\n", FILE_APPEND);
    } catch (Exception $e) {
        file_put_contents('email_errors.txt', "Mailer Error: " . $mail->ErrorInfo . "\n", FILE_APPEND);
    }

    file_put_contents('webhook_log.txt', "Transaction successfully processed: $transactionRef\n", FILE_APPEND);
    http_response_code(200);
    echo json_encode(['status' => 'success', 'message' => 'Transaction processed successfully']);
} else {
    file_put_contents('webhook_log.txt', "Event not 'charge_successful'\n", FILE_APPEND);
}

http_response_code(200);
echo json_encode(['status' => 'success']);
exit();