<?php
include "db_connect.php";
include "register_verify_mailer.php";
$method = $_SERVER['REQUEST_METHOD'];
require __DIR__ . '/vendor/autoload.php';

// Load the `.env` file
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

use Firebase\JWT\JWT;
function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
switch ($method) {
        //  delete acct
    case 'DELETE':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                echo json_encode(
                    [
                        'status' => 200,
                        'success' => true,
                        'message' => 'Authorized'
                    ],
                    JSON_PRETTY_PRINT
                );
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[4]) && is_numeric($path[4])) {
                    $userId = $path[4];
                    if (isset($userId)) {
                        $stmt = $db_connect->prepare("DELETE FROM signup WHERE id = ?");
                        $stmt->bind_param("i", $userId); // "s" indicates the variable type is string
                        if ($stmt->execute()) {
                            http_response_code(200); // OK
                            echo json_encode(
                                [
                                    'status' => 200,
                                    'success' => true,
                                    'message' => 'User has been deleted successfully.',
                                ],
                                JSON_PRETTY_PRINT
                            );
                        } else {
                            http_response_code(400); // Bad Request
                            echo json_encode(
                                [
                                    'status' => 400,
                                    'error' => true,
                                    'message' => 'User could not be deleted',
                                ],
                                JSON_PRETTY_PRINT
                            );
                        }
                    }
                    $stmt->close(); // Closing the statement
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(
                        [
                            'status' => 400,
                            'message' => 'Method not allowed',
                            'error' => true,
                        ],
                        JSON_PRETTY_PRINT
                    );
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }

        break;

        //Registration to ukraft
       case 'POST':

        $userRegistrationForm = json_decode(file_get_contents('php://input'), true);

        // Sanitize inputs
        $name = mysqli_real_escape_string($db_connect, $userRegistrationForm['name']);
        $email = mysqli_real_escape_string($db_connect, $userRegistrationForm['email']);
        $password = password_hash($userRegistrationForm['password'], PASSWORD_BCRYPT);

        // Check if email already exists
        $checkEmailQuery = "SELECT COUNT(*) as emailCount FROM signup WHERE email = '$email'";
        $result = mysqli_query($db_connect, $checkEmailQuery);

        if ($result) {
            $emailRow = mysqli_fetch_assoc($result);
            $emailCount = $emailRow['emailCount'];

            if ($emailCount > 0) {
                http_response_code(400); // Bad Request
                echo json_encode(
                    [
                        'status' => 400,
                        'message' => 'Email already exists',
                        'error' => true,
                    ],
                    JSON_PRETTY_PRINT
                );
                return; // Exit the script early
            }
        }

        // Generate verification code and expiration time
        $verificationCode = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $expiringDate = date("Y-m-d H:i:s", time() + 60 * 5); // Expiration time for the code is 5 mins

        // Insert new user
        $insertUserQuery = "INSERT INTO signup (name, email, password, temp_token_validation, verification_code) 
                    VALUES ('$name', '$email', '$password', '$expiringDate', '$verificationCode')";
        if (mysqli_query($db_connect, $insertUserQuery)) {
            // Fetch the inserted user
            $sql = "SELECT * FROM signup WHERE email = '$email'";
            $result = mysqli_query($db_connect, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                $user = mysqli_fetch_assoc($result);
                $temp_token = $user['temp_token'];

                // JWT Payload
                $secretKey = $_ENV['FIREBASE_SECRET_KEY']; // Use the same secret key
                $algorithm = $_ENV['FIREBASE_ALGORITHM'];

                $payload = [
                    'iss' => 'ukraft',
                    'aud' => 'ukraft',
                    'iat' => time(),
                    'nbf' => time(),
                    'exp' => time() + (60 * 60), // Token expires in 1 hour
                    'userId' => $user['id'],
                    'email' => $user['email']
                ];

                // Encode the JWT
                $jwt = JWT::encode($payload, $secretKey, $algorithm);

                // Store the token in the database
                $updateTokenSql = "UPDATE signup SET token='$jwt' WHERE email='$email'";
                mysqli_query($db_connect, $updateTokenSql);

                // Send verification email
                if(send_Email_Verification($email, $name, $verificationCode)){
                    
                // Success response
                header('Content-Type: application/json');
                echo json_encode(
                    [
                        'status' => 201,
                        'success' => true,
                        'message' => 'Account created successfully! a verification code has been sent to your email address',
                        'email' => $user['email'],
                    ],
                    JSON_PRETTY_PRINT
                );
                }else{
                    header('Content-Type: application/json');
                    echo json_encode(
                        [
                            'status' => 500,
                            'success' => false,
                            'message' => 'User added successfully, but failed to send the email. Please try again later.',
                        ],
                        JSON_PRETTY_PRINT
                    );
                }

                return;
            } else {
                http_response_code(451); // Not working
                echo json_encode(
                    [
                        'status' => 451,
                        'message' => 'Could not retrieve user data after insertion',
                        'error' => true,
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            http_response_code(500); // Internal Server Error
            echo json_encode([
                'status' => 500,
                'error' => true,
                'message' => 'Failed to insert user. Invalid format or database issue.',
            ], JSON_PRETTY_PRINT);
        }

        break;




    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'message' => 'Method not allowed.',
            'error' => true
        ], JSON_PRETTY_PRINT);
        break;
}