<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

function send_Email_Verification($email, $name, $verificationCode)
{
    try {
        // Create an instance; passing `true` enables exceptions
        $mail = new PHPMailer(true);

        // Server settings
        $mail->SMTPDebug = 0;                      // Enable verbose debug output
        $mail->isSMTP();                                            // Send using SMTP
        $mail->Host       = 'ukraftstoreapi.online';                       // Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
        $mail->Username   = 'no_reply@ukraftstoreapi.online';        // SMTP username
        $mail->Password   = '#2244Frixz';                     // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            // Enable implicit TLS encryption
        $mail->Port       = 465;                                    // TCP port to connect to

        // Recipients
        $mail->setFrom('no_reply@ukraftstoreapi.online', 'no_reply@ukraftstoreapi.online');
        $mail->addAddress($email);     // Add recipient

        // Set the Reply-To header to an unmonitored email or invalid domain
        $mail->addReplyTo('no_reply@ukraftstoreapi.onlin', 'No-Reply');

        // Attachments: Add logo and other image
        $mail->addEmbeddedImage('images/logo/logo.png', 'logo_cid');        // Embed the logo image
        // $mail->addEmbeddedImage('path/to/footer_image.png', 'footer_cid'); 

        // Content
        $mail->isHTML(true);  // Set email format to HTML
        $mail->Subject = 'Email Verification From Ukraft';
        $mail->AltBody = 'This is a no-reply email. Please do not respond to this message.'; // Plain text version

        // Email body with embedded images
        $mail->Body = <<<END
            <html>
            <head>
                <title>Verify your email address</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        background-color: white !important;
                        color: black;
                    }
                    .centers {
                        text-align: center;
                        color: #0E0E0E;
                    }
                    .container {
                        max-width: 500px;
                        margin: 0 auto;
                        padding: 15px;
                        border-radius: 10px;
                        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                    }
                    p {
                        font-size: 18px;
                        line-height: 1.6;
                        color: #000000;
                    }
                    .button {
                        display: inline-block;
                        font-weight: 700;
                        padding: 10px 15px;
                        color: #3e4095;
                        text-align: center;
                        text-decoration: none
                       
                    }
                        .images {
                        text-align: center;
                        items-align: center;
                        color: #0E0E0E;
                        }
                    .footer {
                        margin-top: 20px;
                        text-align: center;
                        color: #888;
                    }
                </style>
            </head>
            <body>
                <div class="container">
                    <div class="centers images">
                        <!-- Display the embedded logo -->
                        <img src="cid:logo_cid" alt="Ukraft Logo" width="150" class="images">
                         <h3 class="centers">UKRAFTSTORE</h3>
                    </div>
                    <p>Dear $name,</p>
                    <p>This a one time verification code.</p>
                    <p>Copy the code to verify your email address. expires in the next 5 mins</p>
                    <center>
                        <p class="button">$verificationCode</p>
                    </center>
                    <p>Best regards,</p>
                    <p>The Ukraft Team</p>

                    <div class="footer">
                       <p>&copy; 2025 Ukraft Store. All rights reserved.</p>
</div>
</div>
</body>

</html>
END;

        // Send the email
        $mail->send();
        return json_encode([
            'status' => 200,
            'message' => 'Message has been sent successfully',
        ], JSON_PRETTY_PRINT);
    } catch (Exception $e) {

        return json_encode([
            'status' => 400,
            'error' => $e,
            'message' => 'Could not send mail. Mailer Error: ' . $mail->ErrorInfo
        ], JSON_PRETTY_PRINT);
    }
};