<?php
include "db_connect.php";


function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
        $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
        // to get the items from the database
    case 'GET':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];

                // Proceed with request handling
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/profiles/";
                $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
                if (isset($path[4]) && is_numeric($path[4])) {
                    $json_array = array();
                    $id = $path[4];

                    $stmt = $db_connect->prepare("SELECT 
            signup.id, 
            signup.name AS fullname, 
            signup.email, 
            signup.status, 
            signup.token, 
            customers.username, 
            customers.secondary_email, 
            customers.phone, 
            customers.image, 
            customers.created,
            customers.address_line1 AS residential_address1,
            customers.address_line2 AS residential_address2,
            customers.city, 
            customers.state, 
            customers.zip_code, 
            customers.country, 
            customers.created_at,
            customers.updated_at
       FROM 
        signup
    LEFT JOIN customers ON customers.signup_id = signup.id WHERE signup.id = ?");
                    $stmt->bind_param("s", $id); // "s" indicates the variable type is string
                    $stmt->execute();

                    $result = $stmt->get_result();
                    while ($row = $result->fetch_assoc()) {
                        $imageUrl = $row['image'];
                        if ($imageUrl) {
                            $mageUrl = $baseURL . $imageUrl; // Combine the base URL with the image filename
                        } else {
                            $mageUrl = null; // No image found
                        }
                        $json_array['user'] = array(
                            'id' => $row['id'],
                            'fullname' => $row['fullname'],
                            'email' => $row['email'],
                            'status' => $row['status'],
                            'username' => $row['username'],
                            'secondary_email' => $row['secondary_email'],
                            'phone_number' => $row['phone'],
                            'profile_image' => $mageUrl,
                            'created' => $row['created'],
                            'residential_address1' => $row['residential_address1'],
                            'residential_address2' => $row['residential_address2'],
                            'city' => $row['city'],
                            'state' => $row['state'],
                            'zip_code' => $row['zip_code'],
                            'country' => $row['country'],
                            'created_at' => $row['created_at'],
                            'updated_at' => $row['updated_at'],
                            'token' => $row['token']
                        );
                        if ($token != $row['token']) {
                            echo json_encode([
                                'status' => 404,










                                
                                'error' => true,
                                'message' => 'Unauthorized User.'
                            ], JSON_PRETTY_PRINT);
                            return;
                        } else {

                            echo json_encode($json_array['user']);
                            return;
                        }
                    }

                    $stmt->close();
                } else {
                    $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
                    $stmt = $db_connect->prepare("SELECT 
            signup.id, 
            signup.name AS fullname, 
            signup.email, 
            signup.status, 
            customers.username, 
            customers.secondary_email, 
            customers.phone, 
            customers.image,
            customers.created, 
            customers.address_line1 AS residential_address1,
            customers.address_line2 AS residential_address2,
            customers.city, 
            customers.state, 
            customers.zip_code, 
            customers.country, 
            customers.created_at,
            customers.updated_at
       FROM 
        signup
    LEFT JOIN customers ON customers.signup_id = signup.id WHERE signup.id = ?");
                    $stmt->execute(); // Execute the prepared statement
                    $result = $stmt->get_result(); // Get the result object
                    if ($result->num_rows > 0) {
                        $json_array['user'] = [];
                        while ($row = $result->fetch_assoc()) {
                            $imageUrl = $row['image'];
                            if ($imageUrl) {
                                $mageUrl = $baseURL . $imageUrl; // Combine the base URL with the image filename
                            } else {
                                $mageUrl = null; // No image found
                            }
                            $json_array['user'][] = array(
                                'id' => $row['id'],
                                'fullname' => $row['fullname'],
                                'email' => $row['email'],
                                'status' => $row['status'],
                                'username' => $row['username'],
                                'secondary_email' => $row['secondary_email'],
                                'phone' => $row['phone'],
                                'profile_picture' => $mageUrl,
                                'created' => $row['created'],
                                'residential_address1' => $row['residential_address1'],
                                'residential_address2' => $row['residential_address2'],
                                'city' => $row['city'],
                                'state' => $row['state'],
                                'zip_code' => $row['zip_code'],
                                'country' => $row['country'],
                                'created_at' => $row['created_at'],
                                'updated_at' => $row['updated_at']
                            );
                        }

                        // Prepare the JSON response
                        $response = [
                            'status' => 200,
                            'success' => true,
                            'message' =>  $json_array['user']
                        ];

                        http_response_code(200); // OK
                        echo json_encode($response, JSON_PRETTY_PRINT);
                        return;
                    } else {
                        echo json_encode([
                            'status' => 404,
                            'error' => true,
                            'message' => 'No users found.'
                        ], JSON_PRETTY_PRINT);
                    }
                    $stmt->close(); // Close the statement

                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }


        break;

        // this to delete an item from the database
    case 'DELETE':
        $path = explode('/', $_SERVER["REQUEST_URI"]);
        if (isset($path[4]) && is_numeric($path[4])) {
            $userId = $path[4];

            // Retrieve the image file name from the database
            $stmt = $db_connect->prepare("SELECT image FROM customers WHERE id = ?");
            $stmt->bind_param("s", $userId);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();

            if ($row) {
                $imageToDelete = $row['image'];
                $imagePath = $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles' . "/" . $imageToDelete;

                // Delete the image file from the server's file system
                if (file_exists($imagePath)) {
                    unlink($imagePath);

                    $stmt = $db_connect->prepare("DELETE FROM administratorusers WHERE id = ?");
                    $stmt->bind_param("s", $userId); // "s" indicates the variable type is string
                    if ($stmt->execute()) {
                        http_response_code(200); // OK
                        echo json_encode(
                            [
                                'status' => 200,
                                'success' => true,
                                'message' => 'User records and image has been deleted successfully.'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    } else {
                        http_response_code(400); // Bad Request
                        echo json_encode(
                            [
                                'status' => 400,
                                'error' => true,
                                'message' => 'User record could not be deleted'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }
                }
            }
            $stmt->close(); // Closing the statement
        } else {
            http_response_code(400); // Bad Request
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Method not allowed'
                ],
                JSON_PRETTY_PRINT
            );
        }


        break;




        // and this to send data request to the database in the case registration
  case 'POST':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[4]) && is_numeric($path[4])) {
                    $id = intval($path[4]);

                    // Sanitize and retrieve POST data
                    $fullname = isset($_POST['fullname']) && !empty(trim($_POST['fullname']))
                    ? $db_connect->real_escape_string(trim($_POST['fullname']))
                    : null;

                    $username = isset($_POST['username']) && !empty(trim($_POST['username']))
                    ? $db_connect->real_escape_string(trim($_POST['username']))
                    : null;

                    $email = isset($_POST['email']) && !empty(trim($_POST['email']))
                        ? $db_connect->real_escape_string(trim($_POST['email']))
                        : null;

                    $secondary_email = isset($_POST['secondary_email']) && !empty(trim($_POST['secondary_email']))
                        ? $db_connect->real_escape_string(trim($_POST['secondary_email']))
                        : null;

                    $phone = isset($_POST['phone']) && !empty(trim($_POST['phone']))
                        ? $db_connect->real_escape_string(trim($_POST['phone']))
                        : null;

                    $city = isset($_POST['city']) && !empty(trim($_POST['city']))
                        ? $db_connect->real_escape_string(trim($_POST['city']))
                        : null;

                    $state = isset($_POST['state']) && !empty(trim($_POST['state']))
                        ? $db_connect->real_escape_string(trim($_POST['state']))
                        : null;

                    $zip_code = isset($_POST['zip_code']) && !empty(trim($_POST['zip_code']))
                    ? $db_connect->real_escape_string(trim($_POST['zip_code']))
                    : null;

                    $country = isset($_POST['country']) && !empty(trim($_POST['country']))
                    ? $db_connect->real_escape_string(trim($_POST['country']))
                    : null;

                    $residential_address1 = isset($_POST['residential_address1']) && !empty(trim($_POST['residential_address1']))
                        ? $db_connect->real_escape_string(trim($_POST['residential_address1']))
                        : null;

                    $residential_address2 = isset($_POST['residential_address2']) && !empty(trim($_POST['residential_address2']))
                        ? $db_connect->real_escape_string(trim($_POST['residential_address2']))
                        : null;

                    // Handle file upload
                    $file = isset($_FILES['profile_picture']['name']) && !empty($_FILES['profile_picture']['name'])
                    ? time() . '_' . $_FILES['profile_picture']['name']
                        : null;

                    $file_temp = isset($_FILES['profile_picture']['tmp_name']) && !empty($_FILES['profile_picture']['tmp_name'])
                    ? $_FILES['profile_picture']['tmp_name']
                    : null;

                    $destination = $file
                        ? $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles/' . $file
                        : null;
                    // Check for duplicate secondary_email
                    $query = "SELECT id FROM customers WHERE secondary_email = '$secondary_email' AND signup_id != $id";
                    $result = $db_connect->query($query);
                    if ($result->num_rows > 0) {
                        http_response_code(409);
                        echo json_encode(['status' => 409, 'error' => true, 'message' => 'Secondary email already exists.']);
                        exit;
                    }

                    // Check if the record exists
                    $checkQuery = "SELECT id FROM customers WHERE signup_id = $id";
                    $checkResult = $db_connect->query($checkQuery);

                    if ($checkResult->num_rows > 0) {
                        // Record exists, perform UPDATE
                        $updateQuery = "
            UPDATE signup 
            INNER JOIN customers ON signup.id = customers.signup_id 
            SET 
                signup.name = '$fullname', 
                signup.email = '$email', 
                customers.username = '$username',
                customers.secondary_email = '$secondary_email', 
                customers.phone = '$phone', 
                customers.address_line1 = '$residential_address1', 
                customers.address_line2 = '$residential_address2', 
                customers.city = '$city',
                customers.state = '$state', 
                customers.zip_code = '$zip_code', 
                customers.country = '$country'";

                        // Append image field if file is provided
                        if ($file) {
                            $updateQuery .= ", customers.image = '$file'";
                        }

                        $updateQuery .= " WHERE signup.id = $id";

                        if ($db_connect->query($updateQuery)) {
                            // Move the uploaded file only if provided
                            if ($file) {
                                if (!move_uploaded_file($file_temp, $destination)) {
                                    http_response_code(500);
                                    echo json_encode([
                                        'status' => 500,
                                        'error' => true,
                                        'message' => 'Failed to upload image.'
                                    ], JSON_PRETTY_PRINT);
                                    exit;
                                }
                            }

                            http_response_code(200);
                            echo json_encode([
                                'status' => 200,
                                'success' => true,
                                'message' => 'Profile updated successfully.'
                            ], JSON_PRETTY_PRINT);
                        } else {
                            http_response_code(500);
                            echo json_encode([
                                'status' => 500,
                                'error' => true,
                                'message' => 'Failed to update user profile.'
                            ], JSON_PRETTY_PRINT);
                        }
                    } else {
                        // No record found, perform INSERT
                        $updateQuery = "UPDATE signup SET name='$fullname', email='$email' WHERE id='$id'";


                        if ($db_connect->query($updateQuery)) {
                            // $signupId = $db_connect->insert_id; // Get the inserted signup ID

                            $insertCustomerQuery = "
                INSERT INTO customers (signup_id, username, secondary_email, phone, address_line1, address_line2, city, state, zip_code, country, image) 
                VALUES ($id, '$username', '$secondary_email', '$phone', '$residential_address1', '$residential_address2', '$city', '$state', '$zip_code', '$country', '$file')";

                            if ($db_connect->query($insertCustomerQuery)) {
                                // Move the uploaded file if provided
                                if ($file) {
                                    if (!move_uploaded_file($file_temp, $destination)) {
                                        http_response_code(500);
                                        echo json_encode([
                                            'status' => 500,
                                            'error' => true,
                                            'message' => 'Failed to upload image.'
                                        ], JSON_PRETTY_PRINT);
                                        exit;
                                    }
                                }

                                http_response_code(200);
                                echo json_encode([
                                    'status' => 200,
                                    'success' => true,
                                    'message' => 'Profile created successfully.'
                                ], JSON_PRETTY_PRINT);
                            } else {
                                http_response_code(500);
                                echo json_encode([
                                    'status' => 500,
                                    'error' => true,
                                    'message' => 'Failed to insert customer profile.'
                                ], JSON_PRETTY_PRINT);
                            }
                        } else {
                            http_response_code(500);
                            echo json_encode([
                                'status' => 500,
                                'error' => true,
                                'message' => 'Failed to create user profile.'
                            ], JSON_PRETTY_PRINT);
                        }
                    }
                } else {
                    http_response_code(400);
                    echo json_encode([
                        'status' => 400,
                        'error' => true,
                        'message' => 'Invalid or missing user ID.'
                    ], JSON_PRETTY_PRINT);
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;


    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}