<?php
include "db_connect.php";


function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
        // this to change or edit any of the data from the database
    case 'POST':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT id, token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $signup_id = $userRow['id'];

                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[4]) && is_numeric($path[4])) {
                    $id = intval($path[4]); // Convert to integer to ensure only valid numbers

                    // Sanitize and retrieve POST data
                    $fullname = mysqli_real_escape_string($db_connect, $_POST['fullname'] ?? '');
                    $username = mysqli_real_escape_string($db_connect, $_POST['username'] ?? '');
                    $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
                    $secondary_email = filter_var($_POST['secondary_email'] ?? '', FILTER_SANITIZE_EMAIL);
                    $phone = mysqli_real_escape_string($db_connect, $_POST['phone'] ?? '');
                    $city = mysqli_real_escape_string($db_connect, $_POST['city'] ?? '');
                    $state = mysqli_real_escape_string($db_connect, $_POST['state'] ?? '');
                    $zip_code = mysqli_real_escape_string($db_connect, $_POST['zip_code'] ?? '');
                    $country = mysqli_real_escape_string($db_connect, $_POST['country'] ?? '');
                    $residential_address1 = mysqli_real_escape_string($db_connect, $_POST['residential_address1'] ?? '');
                    $residential_address2 = mysqli_real_escape_string($db_connect, $_POST['residential_address2'] ?? '');

                    // File upload handling
                    $file = $_FILES['profile_picture']['name']
                        ? time() . '_' . basename($_FILES['profile_picture']['name'])
                        : null;
                    $file_temp = $_FILES['profile_picture']['tmp_name'] ?? '';
                    $destination = $file ? $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles/' . $file : null;
                    $created = "true";

                    // Check for duplicate secondary_email
                    $secondary_email_escaped = mysqli_real_escape_string($db_connect, $secondary_email);
                    $query = "SELECT id FROM customers WHERE secondary_email = '$secondary_email_escaped' AND signup_id != $id";
                    $result = mysqli_query($db_connect, $query);

                    if (
                        $result && mysqli_num_rows($result) > 0
                    ) {
                        http_response_code(409);
                        echo json_encode(['status' => 409, 'error' => true, 'message' => 'Secondary email already exists.']);
                        exit;
                    }

                    // Start transaction
                    mysqli_begin_transaction($db_connect);

                    try {
                        // Update the signup table
                        $fullname_escaped = mysqli_real_escape_string($db_connect, $fullname);
                        $email_escaped = mysqli_real_escape_string($db_connect, $email);
                        $updateSignupQuery = "UPDATE signup SET name = '$fullname_escaped', email = '$email_escaped' WHERE id = $id";
                        mysqli_query($db_connect, $updateSignupQuery);

                        // Insert data into the customers table
                        $username_escaped = mysqli_real_escape_string($db_connect, $username);
                        $phone_escaped = mysqli_real_escape_string($db_connect, $phone);
                        $residential_address1_escaped = mysqli_real_escape_string($db_connect, $residential_address1);
                        $residential_address2_escaped = mysqli_real_escape_string($db_connect, $residential_address2);
                        $city_escaped = mysqli_real_escape_string($db_connect, $city);
                        $state_escaped = mysqli_real_escape_string($db_connect, $state);
                        $zip_code_escaped = mysqli_real_escape_string($db_connect, $zip_code);
                        $country_escaped = mysqli_real_escape_string($db_connect, $country);
                        $file_escaped = $file ? mysqli_real_escape_string($db_connect, $file) : null;

                        $insertCustomerQuery = "
            INSERT INTO customers (
                signup_id, username, secondary_email, phone, image, created,
                address_line1, address_line2, city, state, zip_code, country
            )
            VALUES (
                $id, '$username_escaped', '$secondary_email_escaped', '$phone_escaped',
                '$file_escaped', '$created', '$residential_address1_escaped',
                '$residential_address2_escaped', '$city_escaped', '$state_escaped',
                '$zip_code_escaped', '$country_escaped'
            )";
                        mysqli_query($db_connect, $insertCustomerQuery);

                        // Move uploaded file if provided
                        if ($file && !move_uploaded_file($file_temp, $destination)) {
                            throw new Exception('Failed to upload image.');
                        }

                        // Commit transaction
                        mysqli_commit($db_connect);

                        http_response_code(201);
                        echo json_encode([
                            'status' => 201,
                            'success' => true,
                            'message' => 'Profile created and data updated successfully.'
                        ], JSON_PRETTY_PRINT);
                    } catch (Exception $e) {
                        // Rollback transaction
                        mysqli_rollback($db_connect);

                        http_response_code(500);
                        echo json_encode([
                            'status' => 500,
                            'error' => true,
                            'message' => $e->getMessage()
                        ], JSON_PRETTY_PRINT);
                    }
                } else {
                    http_response_code(400);
                    echo json_encode([
                        'status' => 400,
                        'error' => true,
                        'message' => 'Invalid or missing user ID.'
                    ], JSON_PRETTY_PRINT);
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }



        break;



        // and this to send data request to the database in the case registration



    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}