<?php

// Import PHPMailer classes into the global namespace
// These must be at the top of your script, not inside a function
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

//Load Composer's autoloader
require  '../vendor/autoload.php';



function send_order_details($date, $orderId, $amount, $status, $items, $currency, $email)
{
    $subject = "Order Confirmation: Order $orderId";
    $body = "<p>Dear Customer,</p>";
    $body .= "<p>Thank you for your purchase! Here are your order details:</p>";
    $body .= "<ul>";
    foreach ($items as $item) {
        $body .= "<li>Product: {$item['name']} - Quantity: {$item['quantity']} - Price: {$item['price']} $currency</li>";
    }
    $body .= "</ul>";
    $body .= "<p>Total Amount: $amount $currency</p>";
    $body .= "<p>Status: $status</p>";
    $body .= "<p>Order Date: $date</p>";
    $body .= "<p>If you have any questions, feel free to contact us.</p>";
    $body .= "<p>Best regards,<br>Ukraftstore</p>";

    // Use PHPMailer to send the email
    $mail = new PHPMailer(true);
    try {
        // Server settings
        $mail->SMTPDebug = 0;                      // Enable verbose debug output
        $mail->isSMTP();                                            // Send using SMTP
        $mail->Host       = 'ukraftstoreapi.online';                       // Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
        $mail->Username   = 'info@ukraftstoreapi.online';        // SMTP username
        $mail->Password   = '#2244Frixz';                     // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            // Enable implicit TLS encryption
        $mail->Port       = 465;                                    // TCP port to connect to

        // Recipients
        $mail->setFrom('info@ukraftstoreapi.online', 'info@ukraftstoreapi.online');
        $mail->addAddress($email);

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $body;

        $mail->send();
        return true;
    } catch (Exception $e) {
        file_put_contents('email_errors.txt', "Mail Error: " . $mail->ErrorInfo . "\n", FILE_APPEND);
        return false;
    }
}