<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();

$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
    case 'GET':

        if (isset($token)) {
            $stmt = $db_connect->prepare("SELECT token, id FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                $get_id = $userRow['id'];

            
                $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[4]) && is_numeric($path[4])) {
                    $order_id = $path[4];
                    if ($order_id) {
                        $orderData = [];

                        // Get order details
                        $stmt = $db_connect->prepare("SELECT * FROM orders WHERE id = ?");
                        $stmt->bind_param("i", $order_id);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        if ($result->num_rows > 0) {
                            $orderData = $result->fetch_assoc();
                            $orderData['items'] = [];

                            // Billing address for order details
                            $query = "SELECT
                billing_address.id AS billing_address_id,
                billing_address.firstname AS billing_address_firstname,
                billing_address.lastname AS billing_address_lastname,
                billing_address.email AS billing_address_email,
                billing_address.phone AS billing_address_phone,
                billing_address.address AS billing_address_address,
                billing_address.city AS billing_address_city,
                billing_address.state AS billing_address_state,
                billing_address.country AS billing_address_country,
                billing_address.zip_code AS billing_address_zip
            FROM billing_address
            WHERE billing_address.signup_id = ?";

                            $stmt = $db_connect->prepare($query);
                            $stmt->bind_param("i", $get_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($billing_address = $result->fetch_assoc()) {
                                $orderData['billing_address'][] = $billing_address;
                            }

                            // Shipping address for order details
                            $query = "SELECT
                shipping_address.id AS shipping_address_id,
                shipping_address.firstname AS shipping_address_firstname,
                shipping_address.lastname AS shipping_address_lastname,
                shipping_address.email AS shipping_address_email,
                shipping_address.phone AS shipping_address_phone,
                shipping_address.address AS shipping_address_address,
                shipping_address.city AS shipping_address_city,
                shipping_address.state AS shipping_address_state,
                shipping_address.country AS shipping_address_country,
                shipping_address.zip_code AS shipping_address_zip
            FROM shipping_address
            WHERE shipping_address.signup_id = ?";

                            $stmt = $db_connect->prepare($query);
                            $stmt->bind_param("i", $get_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($shipping_address = $result->fetch_assoc()) {
                                $orderData['shipping_address'][] = $shipping_address;
                            }

                            // Define the base URL for images
                            $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";

                            // Order individual items for order details
                            $query = "SELECT order_items.order_id, order_items.product_id, 
                order_items.quantity AS orders_quantity,
                order_items.price AS order_price,
                order_items.created_at AS order_item_time,
                products.name AS product_name,
                products.description AS product_description,
                products.price AS product_price,
                product_images.image_url AS product_image
                FROM order_items
                LEFT JOIN products ON order_items.product_id = products.id
                LEFT JOIN product_images ON product_images.product_id = products.id AND product_images.is_primary = 1
                WHERE order_items.order_id = ?";

                            $stmt = $db_connect->prepare($query);
                            $stmt->bind_param("i", $order_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($item = $result->fetch_assoc()) {
                                // Combine base URL with image filename to create full image URL
                                $item['product_image'] = $item['product_image'] ? $baseURL . $item['product_image'] : null;
                                $orderData['items'][] = $item;
                            }

                            echo json_encode([
                                'status' => 200,
                                'success' => true,
                                'message' => $orderData
                            ], JSON_PRETTY_PRINT);
                        } else {
                            echo json_encode([
                                'status' => 400,
                                'error' => true,
                                'message' => 'No order found.'
                            ], JSON_PRETTY_PRINT);
                        }
                    } else {
                        echo json_encode([
                            'status' => 400,
                            'error' => true,
                            'message' => 'Invalid order id.'
                        ], JSON_PRETTY_PRINT);
                    }
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'POST':
        if (isset($token)) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
$data = json_decode(file_get_contents("php://input"), true);

$user_id = $data['userId'];
$total_amount = $data['total_amount'];
$order_note = $data['order_note'];
$items = $data['items']; // Array of items with product_id, quantity, price

// Generate a unique order reference
$order_ref = uniqid('ORDER_', true);

// Start transaction
$db_connect->begin_transaction();

try {
    // Check if there's already a pending order with the same user_id and total_amount
    $check_query = "SELECT * FROM orders WHERE signup_id = '$user_id' AND total_amount = '$total_amount' AND status = 'pending'";
    $check_result = mysqli_query($db_connect, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        // Fetch the existing order
        $existing_order = mysqli_fetch_assoc($check_result);
        $existing_order_id = $existing_order['id'];

        http_response_code(200);
        echo json_encode(
            [
                'status' => 200,
                'success' => true,
                'message' => "Order already exists, proceed with payment",
                'order_id' => $existing_order_id,
                'order_ref' => $existing_order['order_ref'],
            ],
            JSON_PRETTY_PRINT
        );
        $db_connect->rollback(); // No changes made, rollback
        
    }

    // Insert into Orders table
    $insert_order_query = "INSERT INTO orders (signup_id, total_amount, order_note, order_ref, status) 
                           VALUES ('$user_id', '$total_amount', '$order_note', '$order_ref', 'pending')";
    if (!mysqli_query($db_connect, $insert_order_query)) {
        throw new Exception("Failed to insert order: " . mysqli_error($db_connect));
    }
    $order_id = mysqli_insert_id($db_connect);

    // Insert each item into OrderItems table
    foreach ($items as &$item) { // Use reference to modify $items directly
        $product_id = $item['product_id'];
        $quantity = $item['quantity'];
        $price = $item['price'];

        $insert_item_query = "INSERT INTO order_items (order_id, product_id, quantity, price) 
                              VALUES ('$order_id', '$product_id', '$quantity', '$price')";
        if (!mysqli_query($db_connect, $insert_item_query)) {
            throw new Exception("Failed to insert order item: " . mysqli_error($db_connect));
        }

        // Add order_id to each item
        $item['order_id'] = $order_id;
    }

    // Commit transaction
    $db_connect->commit();
    http_response_code(200);
    echo json_encode(
        [
            'status' => 200,
            'success' => true,
            'message' => "Preliminary order created successfully",
            'order_id' => $order_id,
            'order_ref' => $order_ref,
            'items' => $items,
        ],
        JSON_PRETTY_PRINT
    );
} catch (Exception $e) {
    // Rollback transaction in case of error
    $db_connect->rollback();
    http_response_code(400);
    echo json_encode(
        [
            'status' => 400,
            'error' => true,
            'message' => "Failed to place order",
            "details" => $e->getMessage()
        ],
        JSON_PRETTY_PRINT
    );
}

            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        $db_connect->close();


        break;
    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode(
            [
                'status' => 405,
                'error' => true,
                'message' => 'Method not allowed.'
            ],
            JSON_PRETTY_PRINT
        );
}