<?php
include "db_connect.php";
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':

        $path = explode('/', $_SERVER["REQUEST_URI"]);
        if (isset($path[4]) && is_numeric($path[4])) {
            $json_array = array();
            $user_id = $path[4];



            // Query to get the total orders by status
            $query = "SELECT 
        COUNT(CASE WHEN status = 'complete' THEN 1 END) AS completed_orders,
        COUNT(CASE WHEN status = 'pending' THEN 1 END) AS pending_orders,
        COUNT(*) AS total_orders
    FROM orders
    WHERE signup_id = ?
";

            // Prepare the statement
            $stmt = mysqli_prepare($db_connect, $query);

            if ($stmt) {
                // Bind the user ID to the query
                mysqli_stmt_bind_param($stmt, "i", $user_id);

                // Execute the query
                mysqli_stmt_execute($stmt);

                // Bind the results to variables
                mysqli_stmt_bind_result($stmt, $completed_orders, $pending_orders, $total_orders);

                // Fetch the results
                if (mysqli_stmt_fetch($stmt)) {
                    // Prepare the response
                    $response = [
                        "completed_orders" => $completed_orders,
                        "pending_orders" => $pending_orders,
                        "total_orders" => $total_orders,
                    ];

                    // Send the response as JSON
                    echo json_encode($response);
                } else {
                    echo json_encode(["error" => "No orders found for this user."]);
                }

                // Close the statement
                mysqli_stmt_close($stmt);
            } else {
                echo json_encode(["error" => "Failed to prepare the SQL statement."]);
            }

            // Close the database connection
            mysqli_close($db_connect);
        } else {
            echo json_encode([
                'status' => 404,
                'error' => true,
                'message' => 'The id is not found in the url'
            ], JSON_PRETTY_PRINT);
        }


        break;

    default:
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}