<?php
include "db_connect.php";

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        $sql = "SELECT * FROM newsletter";
        $stmt = $db_connect->prepare($sql);
        $stmt->execute(); // Execute the prepared statement
        $result = $stmt->get_result(); // Get the result object
        if ($result->num_rows > 0) {
            $json_array['newsletter'] = [];
            while ($row = $result->fetch_assoc()) {
                $json_array['newsletter'][] = array(
                    'id' => $row['id'],
                    'email' => $row['email'],
                    'status' => $row['status'],
                    'created_at' => $row['created_at']
                );
            }
            // Prepare the JSON response
            $response = [
                'status' => 200,
                'success' => true,
                'message' =>  $json_array['newsletter']
            ];

            http_response_code(200); // OK
            echo json_encode($response, JSON_PRETTY_PRINT);
            return;
        } else {
            echo json_encode([
                'status' => 404,
                'error' => true,
                'message' => 'No newsletter email found.'
            ], JSON_PRETTY_PRINT);
        }
        $stmt->close(); // Close the statement
        break;


    case 'POST':

        $data = json_decode(file_get_contents('php://input'));
        $email = $data->email;
        $status = "true";
        // // Check if the input data is valid
        if (isset($email)) {
            $sql = "INSERT INTO newsletter (email, status) VALUES (?, ?)";
            $stmt = $db_connect->prepare($sql);
            $stmt->bind_param('ss', $email, $status);
            if ($stmt->execute()) {
                header('Content-Type: application/json');
                http_response_code(200); // Bad Request
                echo json_encode([
                    'status' => 200,
                    'error' => true,
                    'message' => 'Email has been added to our records.',
                ], JSON_PRETTY_PRINT);
            } else {
                header('Content-Type: application/json');
                http_response_code(400); // Bad Request
                echo json_encode([
                    'status' => 400,
                    'error' => true,
                    'message' => 'Email was not added to our records.',
                ], JSON_PRETTY_PRINT);
            }
        }
        break;

    default:
        http_response_code(451); // Method not allow
        echo json_encode(
            [
                'status' => 404,
                'message' => 'Nethod not allowed',
                'error' => true,
            ],
            JSON_PRETTY_PRINT
        );
        break;
}