<?php
include("db_connect.php");



function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
if ($token) {
    // Use mysqli_query to fetch the token
    $query = "SELECT token FROM signup WHERE token = '$token'";
    $result = mysqli_query($db_connect, $query);

    if (mysqli_num_rows($result) > 0) {
        // Token is valid
        $userRow = mysqli_fetch_assoc($result);
        $get_token = $userRow['token'];

        $path = explode('/', $_SERVER["REQUEST_URI"]);
        if (isset($path[4]) && is_numeric($path[4])) {
            $json_array = array();
            $userId = $path[4];

            // Update the status in the database using mysqli_query
            $updateStatusSql = "UPDATE signup SET token = NULL WHERE id = $userId";
            $execute = mysqli_query($db_connect, $updateStatusSql);

            if ($execute) {
                header('Content-Type: application/json');
                echo json_encode(
                    [
                        'status' => 200,
                        'success' => true,
                        'message' => 'Logged out successfully'
                    ],
                    JSON_PRETTY_PRINT
                );
            } else {
                header('Content-Type: application/json');
                echo json_encode(['failed' => "Did not log out successfully"]);
            }
        } else {
            // Session is not active, respond with an error
            header('Content-Type: application/json');
            echo json_encode(
                [
                    'status' => 400,
                    'false' => true,
                    'message' => 'No active token/session found'
                ],
                JSON_PRETTY_PRINT
            );
        }
    } else {
        // Invalid token
        http_response_code(401);
        echo json_encode(
            [
                'status' => 401,
                'error' => true,
                'message' => 'Invalid token'
            ],
            JSON_PRETTY_PRINT
        );
    }
} else {
    // No token provided
    http_response_code(400);
    echo json_encode(
        [
            'status' => 400,
            'error' => true,
            'message' => 'Authorization token missing'
        ],
        JSON_PRETTY_PRINT
    );
}
