<?php
include("db_connect.php");
include "register_verify_mailer.php";

// Include the Composer autoload file
require __DIR__ . '/vendor/autoload.php';

// Load the `.env` file
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

// Parse the incoming JSON payload
$userLoginForm = json_decode(file_get_contents('php://input'));
$email = mysqli_real_escape_string($db_connect, $userLoginForm->email);
$password = $userLoginForm->password;

// Fetch user data
$sql = "SELECT * FROM signup WHERE email = '$email'";
$result = mysqli_query($db_connect, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $user = mysqli_fetch_assoc($result);

    // Verify the hash password
    if (password_verify($password, $user['password']) && $email === $user['email']) {
        if ($user['status'] === 'pending') {
            $name = $user['name'];
            $verificationCode = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
            $expiringDate = date("Y-m-d H:i:s", time() + 60 * 5); // Set expiry time
            
            // Update the verification code
            $updateVerificationSql = "
                UPDATE signup 
                SET verification_code = '$verificationCode', temp_token_validation = '$expiringDate' 
                WHERE email = '$email'
            ";
            if (mysqli_query($db_connect, $updateVerificationSql)) {
                send_Email_Verification($email, $name, $verificationCode);
                http_response_code(400); // Bad Request
                echo json_encode([
                    'status' => 400,
                    'error' => true,
                    'message' => 'Email address not verified, email verification has been sent to your mail.'
                ], JSON_PRETTY_PRINT);
                die("ERROR: Verify your email address");
            }
        }

        $secretKey = $_ENV['FIREBASE_SECRET_KEY']; // Use the same secret key
        $algorithm = $_ENV['FIREBASE_ALGORITHM'];

        $payload = [
            'iss' => 'ukraft',
            'aud' => 'ukraft',
            'iat' => time(),
            'nbf' => time(),
            'exp' => time() + (60 * 60), // Token expires in 1 hour
            'userId' => $user['id'],
            'email' => $user['email'],
        ];

        // Encode the JWT
        $jwt = \Firebase\JWT\JWT::encode($payload, $secretKey, $algorithm);

        // Update the token in the database
        $updateTokenSql = "UPDATE signup SET token = '$jwt' WHERE id = {$user['id']}";
        if (mysqli_query($db_connect, $updateTokenSql)) {
            // Fetch updated user info
            $fetchUpdatedUserSql = "SELECT id, name, email, token FROM signup WHERE email = '$email'";
            $result = mysqli_query($db_connect, $fetchUpdatedUserSql);
            if ($result && mysqli_num_rows($result) > 0) {
                $userRow = mysqli_fetch_assoc($result);
                echo json_encode([
                    'status' => 200,
                    'success' => true,
                    'message' => 'Login successfully',
                    'userinfo' => [
                        'token' => $userRow['token'],
                        'user' => [
                            'userId' => $userRow['id'],
                            'name' => $userRow['name'],
                            'email' => $userRow['email'],
                        ]
                    ]
                ], JSON_PRETTY_PRINT);
            }
        }
    } else {
        http_response_code(400); // Bad Request
        echo json_encode([
            'status' => 400,
            'message' => 'Invalid password',
            'error' => true,
        ], JSON_PRETTY_PRINT);
    }
} else {
    http_response_code(404); // Not Found
    echo json_encode([
        'status' => 404,
        'message' => 'User Not Found',
        'error' => true,
    ], JSON_PRETTY_PRINT);
}

mysqli_close($db_connect); // Close the database connection
