<?php
include "db_connect.php";
header("Content-Type: application/json");
require __DIR__ . '/vendor/autoload.php';

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

$expectedPublicKey = $_ENV['SQUAD_PUBLIC_KEY'];
$method = $_SERVER['REQUEST_METHOD'];

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}

function getBearerToken()
{
    $headers = getAuthorizationHeader();
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}

$token = getBearerToken();

if ($method === 'POST') {
    if ($token) {
        $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
        $stmt->bind_param("s", $token);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $requestData = json_decode(file_get_contents('php://input'), true);

            if (
                isset(
                    $requestData['amount'],
                    $requestData['currency'],
                    $requestData['email'],
                    $requestData['customerName'],
                    $requestData['publicKey'],
                    
                    $requestData['items']

                ) &&
                $expectedPublicKey === $requestData['publicKey']
            ) {
                initiateSquadPayment(
                    $requestData['amount'],
                    $requestData['currency'],
                    $requestData['email'],
                    $requestData['customerName'],
                 
                    $requestData['items']

                );
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'Invalid request parameters']);
            }
        } else {
            http_response_code(401);
            echo json_encode(['error' => 'Invalid token']);
        }
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Authorization token missing']);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed.']);
}

function initiateSquadPayment($amount, $currency, $email, $customerName, $items)
{
    $url = "https://api-d.squadco.com/transaction/initiate";
    // "https://sandbox-api-d.squadco.com/transaction/initiate";
    $apiKey = $_ENV['SQUAD_SECRET_KEY'];

    if (empty($apiKey)) {
        echo json_encode(['error' => 'API key is missing']);
        return;
    }

    $metadata = [
        // 'order_id' => (string)$order_id, // Ensure order_id is a string
        'items' => $items, // Include the items array
    ];



    $data = [
        "amount" => $amount * 100, // Convert to cents
        "email" => $email,
        "currency" => $currency,
        "initiate_type" => "inline",
        "customer_name" => $customerName,
        "metadata" => $metadata, // Add metadata here
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        http_response_code(500);
        echo json_encode(['error' => curl_error($ch)]);
        curl_close($ch);
        return;
    }

    curl_close($ch);
    $responseData = json_decode($response, true);

    if (isset($responseData['data']['checkout_url'])) {
        echo json_encode(['paymentUrl' => $responseData['data']['checkout_url']]);
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Payment initiation failed', 'details' => $responseData]);
    }
}