<?php
include "db_connect.php";
include "ukraft_mailer.php";


require 'vendor/autoload.php';

$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {

        // and this to send data request to the database in the case registration
    case 'POST':

        $data = json_decode(file_get_contents('php://input'), true);
        // Get the raw POST data
        $email = $data['email'];
        $subject = $data['subject'];
        $message = $data['message'];
        if (isset($email) && isset($subject)) {
            // update user image
            $insertUserQuery = "INSERT INTO contact (email,subject,message) VALUES (?, ?, ?)";
            $stmt = $db_connect->prepare($insertUserQuery);
            $stmt->bind_param("sss", $email, $subject, $message,); // "si" indicates 1 strings and one integer
            if ($stmt->execute()) {
                $stmt = $db_connect->prepare("SELECT * FROM contact WHERE email = ?");
                $stmt->bind_param("s", $email);
                $stmt->execute();
                $result = $stmt->get_result();
                if ($result->num_rows > 0) {
                    // Token is valid
                    $row = $result->fetch_assoc();
                    $get_email = $row['email'];
                    $get_subject = $row['subject'];
                    $get_message = $row['message'];
                    header('Content-Type: application/json');
                    thank_you_for_contacting_us($get_email, $get_subject, $get_message);
                }
                http_response_code(200);
                echo json_encode(
                    [
                        'status' => 200,
                        'success' => true,
                        'message' => 'query has been uploaded successfully',
                        'sub_message' => 'A confirmation email has been sent to this address. Thank you for reaching out to us.'
                    ],
                    JSON_PRETTY_PRINT
                );
            } else {
                http_response_code(400); // not working
                echo json_encode(
                    [
                        'status' => 400,
                        'error' => true,
                        'messasge' => 'Could not upload query'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            http_response_code(451); // not working
            echo json_encode(
                [
                    'status' => 451,
                    'error' => true,
                    'message' => 'email address not not found'
                ],
                JSON_PRETTY_PRINT
            );
        }

        break;


    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}