<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}

function getBearerToken()
{
    $headers = getAuthorizationHeader();
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}

$token = getBearerToken();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'POST':
        $changePassword = json_decode(file_get_contents('php://input'));
        $password = mysqli_real_escape_string($db_connect, $changePassword->password);
        $token = mysqli_real_escape_string($db_connect, $changePassword->token);

        if (isset($password) && isset($token)) {
            $password_hash = password_hash($password, PASSWORD_DEFAULT);

            $check_token = "SELECT * FROM signup WHERE temp_token = '$token' LIMIT 1";
            $result = mysqli_query($db_connect, $check_token);

            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $get_email = $row['email'];
                $get_db_timer = strtotime($row['temp_token_validation']);
                $current_Time = time();
                $timeDiffent = $get_db_timer - $current_Time;

                if ($timeDiffent >= 1800) {
                    http_response_code(400); // Bad Request
                    echo json_encode([
                        'status' => 400,
                        'error' => true,
                        'message' => 'Your token has expired!',
                    ], JSON_PRETTY_PRINT);
                    die();
                } else {
                    $update_password = "
                        UPDATE signup 
                        SET password = '$password_hash', temp_token = NULL, temp_token_validation = NULL 
                        WHERE email = '$get_email' LIMIT 1";
                    
                    if (mysqli_query($db_connect, $update_password)) {
                        echo json_encode([
                            'status' => 200,
                            'success' => true,
                            'message' => 'Password has been updated successfully',
                        ], JSON_PRETTY_PRINT);
                    } else {
                        http_response_code(400); // Bad Request
                        echo json_encode([
                            'status' => 400,
                            'message' => 'Could not update password',
                            'error' => true,
                        ], JSON_PRETTY_PRINT);
                    }
                }
            } else {
                http_response_code(404); // Not Found
                echo json_encode([
                    'status' => 404,
                    'error' => true,
                    'message' => 'Invalid token',
                ], JSON_PRETTY_PRINT);
            }
        }
        break;

    case 'PUT':
        if (!empty($token)) {
            $token = mysqli_real_escape_string($db_connect, $token);
            $check_token = "SELECT token, password FROM signup WHERE token = '$token'";
            $result = mysqli_query($db_connect, $check_token);

            if ($result && mysqli_num_rows($result) > 0) {
                $userRow = mysqli_fetch_assoc($result);
                $get_password = $userRow['password'];

                $changePassword = json_decode(file_get_contents('php://input'));
                $id = mysqli_real_escape_string($db_connect, $changePassword->id);
                $currentPassword = mysqli_real_escape_string($db_connect, $changePassword->currentPassword);
                $newPassword = mysqli_real_escape_string($db_connect, $changePassword->newPassword);
                $password_hash = password_hash($newPassword, PASSWORD_DEFAULT);

                $verifyOldPassword = password_verify($currentPassword, $get_password);
                if ($verifyOldPassword === true) {
                    $update_password = "UPDATE signup SET password = '$password_hash' WHERE id = '$id' LIMIT 1";
                    if (mysqli_query($db_connect, $update_password)) {
                        echo json_encode([
                            'status' => 200,
                            'success' => true,
                            'message' => 'Password has been updated successfully',
                        ], JSON_PRETTY_PRINT);
                    } else {
                        http_response_code(400); // Bad Request
                        echo json_encode([
                            'status' => 400,
                            'message' => 'Could not update password',
                            'error' => true,
                        ], JSON_PRETTY_PRINT);
                    }
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode([
                        'status' => 400,
                        'message' => 'Incorrect password',
                        'error' => true,
                    ], JSON_PRETTY_PRINT);
                }
            } else {
                http_response_code(401); // Unauthorized
                echo json_encode([
                    'status' => 401,
                    'error' => true,
                    'message' => 'Invalid token',
                ], JSON_PRETTY_PRINT);
            }
        } else {
            http_response_code(400); // Bad Request
            echo json_encode([
                'status' => 400,
                'error' => true,
                'message' => 'Authorization token missing',
            ], JSON_PRETTY_PRINT);
        }
        break;

    default:
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed',
        ], JSON_PRETTY_PRINT);
        break;
}
