<?php
include "db_connect.php";

use Firebase\JWT\JWT;

require 'vendor/autoload.php';
function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
        // to get the items from the database
    case 'GET':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];

                // Proceed with request handling
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
                if (isset($path[4]) && is_numeric($path[4])) {
                    $json_array = array();
                    $id = $path[4];

                    $stmt = $db_connect->prepare("SELECT 
            signup.id, 
            signup.token, 
            billing_address.firstname, 
            billing_address.lastname,
            billing_address.company_name, 
            billing_address.email, 
            billing_address.phone, 
            billing_address.address,
            billing_address.zip_code, 
            billing_address.city, 
            billing_address.state, 
            billing_address.country, 
            billing_address.created_at,
            billing_address.updated_at
       FROM 
        signup
    LEFT JOIN billing_address ON billing_address.signup_id = signup.id WHERE signup.id = ?");
                    $stmt->bind_param("i", $id); // "s" indicates the variable type is string
                    $stmt->execute();

                    $result = $stmt->get_result();
                    while ($row = $result->fetch_assoc()) {
                        $json_array['user'] = array(
                            'id' => $row['id'],
                            'firstname' => $row['firstname'],
                            'lastname' => $row['lastname'],
                            'company_name' => $row['company_name'],
                            'email' => $row['email'],
                            'phone' => $row['phone'],
                            'address' => $row['address'],
                            'zip_code' => $row['zip_code'],
                            'city' => $row['city'],
                            'state' => $row['state'],
                            'country' => $row['country'],
                            'created_at' => $row['created_at'],
                            'updated_at' => $row['updated_at'],
                            'token' => $row['token']
                        );
                        if ($token != $row['token']) {
                            echo json_encode([
                                'status' => 404,
                                'error' => true,
                                'message' => 'Unauthorized User.'
                            ], JSON_PRETTY_PRINT);
                            return;
                        } else {

                            // echo json_encode($json_array['user']);
                            http_response_code(200);
                            echo json_encode(
                                [
                                    'status' => 200,
                                    'success' => true,
                                    'message' => $json_array['user']
                                ],
                                JSON_PRETTY_PRINT
                            );
                            return;
                        }
                    }

                    $stmt->close();
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }


        break;


        // and this to send data request to the database in the case registration
    case 'POST':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];

                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[4]) && is_numeric($path[4])) {
                    $id = $path[4];
                    // Get the raw POST data
                    $data = json_decode(file_get_contents('php://input'), true);

                    $firstname = isset($data['firstname']) || !empty($data['firstname']) ? $data['firstname'] : null;
                    $lastname = isset($data['lastname']) || !empty($data['lastname']) ? $data['lastname'] : null;
                    $company_name = isset($data['company_name']) || !empty($data['company_name']) ? $data['company_name'] : null;
                    $email = isset($data['email']) || !empty($data['email']) ? $data['email'] : null;
                    $phone = isset($data['phone']) || !empty($data['phone']) ? $data['phone'] : null;
                    $address = isset($data['address']) || !empty($data['address']) ? $data['address'] : null;
                    $zip_code = isset($data['zip_code']) || !empty($data['zip_code']) ? $data['zip_code'] : null;
                    $city = isset($data['city']) || !empty($data['city']) ? $data['city'] : null;
                    $state = isset($data['state']) || !empty($data['state']) ? $data['state'] : null;
                    $country = isset($data['country']) || !empty($data['country']) ? $data['country'] : null;

                    if ($id) {
                        // Check if the record already exists
                        $checkQuery = "SELECT id FROM billing_address WHERE signup_id = ?";
                        $stmt = $db_connect->prepare($checkQuery);
                        $stmt->bind_param("i", $id);
                        $stmt->execute();
                        $result = $stmt->get_result();

                        if ($result->num_rows > 0) {
                            // Record exists, perform UPDATE
                            $updateQuery = "UPDATE billing_address 
                            SET firstname = ?, lastname = ?, company_name = ?, email = ?, phone = ?, 
                                address = ?, zip_code = ?, city = ?, state = ?, country = ? 
                            WHERE signup_id = ?";
                            $stmt = $db_connect->prepare($updateQuery);
                            $stmt->bind_param(
                                "ssssssssssi",
                                $firstname,
                                $lastname,
                                $company_name,
                                $email,
                                $phone,
                                $address,
                                $zip_code,
                                $city,
                                $state,
                                $country,
                                $id
                            );

                            if ($stmt->execute()) {
                                http_response_code(200);
                                echo json_encode(
                                    [
                                        'status' => 200,
                                        'success' => true,
                                        'message' => 'Billing address updated successfully.'
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                            } else {
                                http_response_code(400); // Bad Request
                                echo json_encode(
                                    [
                                        'status' => 400,
                                        'error' => true,
                                        'message' => 'Could not update billing address.'
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                            }
                        } else {
                            // Record does not exist, perform INSERT
                            $insertBillingQuery = "INSERT INTO billing_address (
                signup_id, 
                firstname, 
                lastname, 
                company_name, 
                email, 
                phone, 
                address, 
                zip_code, 
                city, 
                state, 
                country
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            $stmt = $db_connect->prepare($insertBillingQuery);
                            $stmt->bind_param(
                                "issssssssss",
                                $id,
                                $firstname,
                                $lastname,
                                $company_name,
                                $email,
                                $phone,
                                $address,
                                $zip_code,
                                $city,
                                $state,
                                $country
                            );

                            if ($stmt->execute()) {
                                http_response_code(200);
                                echo json_encode(
                                    [
                                        'status' => 200,
                                        'success' => true,
                                        'message' => 'Billing address inserted successfully.'
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                            } else {
                                http_response_code(400); // Bad Request
                                echo json_encode(
                                    [
                                        'status' => 400,
                                        'error' => true,
                                        'message' => 'Could not insert billing address.'
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                            }
                        }
                    } else {
                        http_response_code(451); // Unavailable for Legal Reasons
                        echo json_encode(
                            [
                                'status' => 451,
                                'error' => true,
                                'message' => 'Did not get the ID from client side.'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }
                } else {
                    http_response_code(451); // Unavailable for Legal Reasons
                    echo json_encode(
                        [
                            'status' => 451,
                            'error' => true,
                            'message' => 'ID not found.'
                        ],
                        JSON_PRETTY_PRINT
                    );
                }

            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'PUT':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];

                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[4]) && is_numeric($path[4])) {
                    $id = $path[4];
                    // Get the raw POST data
                    $data = json_decode(file_get_contents('php://input'), true);

                    $firstname = $data['firstname'];
                    $lastname = $data['lastname'];
                    $company_name = $data['company_name'];
                    $email = $data['email'];
                    $phone = $data['phone'];
                    $address = $data['address'];
                    $zip_code = $data['zip_code'];
                    $city = $data['city'];
                    $state = $data['state'];
                    $country = $data['country'];

                    if ($id) {
                        // Insert new billing address
                        $updateBillingQuery = "UPDATE billing_address 
    SET 
        firstname = ?, 
        lastname = ?, 
        company_name = ?, 
        email = ?, 
        phone = ?, 
        address = ?, 
        zip_code = ?, 
        city = ?, 
        state = ?, 
        country = ? 
    WHERE signup_id = ?";

                        $stmt = $db_connect->prepare($updateBillingQuery);
                        $stmt->bind_param(
                            "ssssssssssi",
                            $firstname,
                            $lastname,
                            $company_name,
                            $email,
                            $phone,
                            $address,
                            $zip_code,
                            $city,
                            $state,
                            $country,
                            $id
                        );

                        if ($stmt->execute()) {
                            http_response_code(200);
                            echo json_encode(
                                [
                                    'status' => 200,
                                    'success' => true,
                                    'message' => 'Billing address updated successfully.'
                                ],
                                JSON_PRETTY_PRINT
                            );
                        } else {
                            http_response_code(400); // Bad Request
                            echo json_encode(
                                [
                                    'status' => 400,
                                    'error' => true,
                                    'message' => 'Could not insert billing address.'
                                ],
                                JSON_PRETTY_PRINT
                            );
                        }
                    } else {
                        http_response_code(451); // Unavailable for Legal Reasons
                        echo json_encode(
                            [
                                'status' => 451,
                                'error' => true,
                                'message' => 'Did not get the ID from client side.'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }
                } else {
                    http_response_code(451); // Unavailable for Legal Reasons
                    echo json_encode(
                        [
                            'status' => 451,
                            'error' => true,
                            'message' => 'ID not found.'
                        ],
                        JSON_PRETTY_PRINT
                    );
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}