<?php

// Import PHPMailer classes into the global namespace
// These must be at the top of your script, not inside a function
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

//Load Composer's autoloader
require  '../vendor/autoload.php';



function send_password_reset($get_name, $get_email, $token_hash)
{

    try {
        //Create an instance; passing `true` enables exceptions
        $mail = new PHPMailer(true);


        //Server settings
        $mail->SMTPDebug = 0;                      //Enable verbose debug output
        $mail->isSMTP();                                            //Send using SMTP
        $mail->Host       = 'ukraftstoreapi.online';                     //Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
        $mail->Username   = 'no_reply@ukraftstoreapi.online';                     //SMTP username
        $mail->Password   = '#2244Frixz';                                //SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
        $mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

        //Recipients
        $mail->setFrom('no_reply@ukraftstoreapi.online', 'no_reply@ukraftstoreapi.online');
        $mail->addAddress($get_email);     //Add a recipient
        // Set the Reply-To header to an unmonitored email or invalid domain
        $mail->addReplyTo('no_reply@ukraftstoreapi.online', 'No-Reply');

        $mail->addEmbeddedImage('../images/logo/logo.png', 'logo_cid');

        //Content
        $mail->isHTML(true);
        $mail->Subject = 'Reset Password Notification';
        $mail->AltBody = 'This is a no-reply email. Please do not respond to this message.'; // Plain text version
        $mail->Body = <<<END

            <html>
            <head>
                <title>Reset Your Password now</title>
                <style>
                    /* Add CSS styles here */
                    body {
                        font-family: Arial, sans-serif;
                        background-color: white !important;
                        color: black ;
                    }
                    .centers{
                        text-align: center;
                        color: #0E0E0E;
                    }
                    .container {
                        max-width: 500px;
                        margin: 0 auto;
                        padding: 15px;
                        background-color: #FFFFFF;
                        border-radius: 10px;
                        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                    }

                    p {
                        font-size: 18px;
                        line-height: 1.6;
                        color: #000000;
                    }
                    .button {
                        display: inline-block;
                        padding: 10px 15px;
                        background-color: #0B0FF3;
                        color: #000000;
                        text-align: center;
                        text-decoration: none;
                        border-radius: 10px;
                    }
                         .images {
                        text-align: center;
                        items-align: center;
                        color: #0E0E0E;
                        }
                    .footer {
                        margin-top: 20px;
                        text-align: center;
                        color: #888;
                    }
                </style>
            </head>
            <body>
                <div class="container">
                 <div class="centers images">
                        <!-- Display the embedded logo -->
                        <img src="cid:logo_cid" alt="Ukraft Logo" width="150" class="images">
                         <h3 class="centers">UKRAFTSTORE</h3>
                    </div>
                <p>Dear $get_name,</p>
                <p>You are recieving this email because you have resquested for a password reset.</p><br>
               <p> Note that this a one time password reset mail, this link will expires in the next 30 mins. </p>
               <p>Keep your password save at all times.</p>
               <p>This password reset is associated with ukraftstore.</p>
               <p>Best regards, </p>
               <p>The Ukraftstore Team.</p>
               <center>
               <a href="https://www.ukraftstore.com/reset-password?token=$token_hash" style="color: #FFFFFF" class="button">Reset Password</a>
               </center>
               <p>If password reset was not initiated by you, please ignore, thanks!</p>
                      <div class="footer">
                       <p>&copy; 2025 Ukraft Store. All rights reserved.</p>
</div>
</div>
</body>

</html>


END;

        $mail->send();
        return json_encode([
            'status' => 200,
            'success' => true,
            'message' => 'Mail has been sent to you successfully',
        ], JSON_PRETTY_PRINT);
    } catch (Exception $e) {

        return json_encode([
            'status' => 400,
            'error' => $e->getMessage(),
            'Could not send mail. Mailer Error: ',
            [$mail->ErrorInfo]
        ], JSON_PRETTY_PRINT);
    };
};