<?php
include "db_connect.php";
$method = $_SERVER['REQUEST_METHOD'];


use Firebase\JWT\JWT;

require '../vendor/autoload.php';
function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
$baseURL = "https://www.ukraftstore.com/ukraft/api/images/profiles/";
switch ($method) {
        // to get the items from the database
    case 'GET':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $json_array = array();
                    $userId = $path[5];

                    $stmt = $db_connect->prepare("SELECT * FROM admin_user WHERE id = ?");
                    $stmt->bind_param("i", $userId); // "s" indicates the variable type is string
                    $stmt->execute();
                    $result = $stmt->get_result();
                    while ($usersRow = $result->fetch_assoc()) {
                        $json_array['users'] = array(
                            'id' => $usersRow['id'],
                            'name' => $usersRow['name'],
                            'username' => $usersRow['username'],
                            'email' => $usersRow['email'],
                        );

                        echo json_encode($json_array['users']);
                        return;
                    }

                    $stmt->close();
                } else {
                    $destination = $_SERVER['DOCUMENT_ROOT'] . '/skillwave' . "/";
                    $stmt = $db_connect->prepare("SELECT * FROM admin_user");
                    $stmt->execute(); // Execute the prepared statement
                    $result = $stmt->get_result(); // Get the result object
                    if ($result->num_rows > 0) {
                        $json_array['users'] = [];
                        while ($row = $result->fetch_assoc()) {
                            $imageUrl = $row['image'];
                            $fullImageUrl = $imageUrl ? $baseURL . $imageUrl : "";
                            $json_array['users'][] = array(
                                'id' => $row['id'],
                                'name' => $row['name'],
                                'username' => $row['username'],
                                'email' => $row['email'],
                                'role' => $row['role'],
                                'image' => $fullImageUrl,
                                'timestamp' => $row['timestamp']
                            );
                        }
                        // Prepare the JSON response
                        $response = [
                            'status' => 200,
                            'success' => true,
                            'message' =>  $json_array['users']
                        ];

                        http_response_code(200); // OK
                        echo json_encode($response, JSON_PRETTY_PRINT);
                        return;
                    } else {
                        echo json_encode([
                            'status' => 404,
                            'error' => true,
                            'message' => 'No users found.'
                        ], JSON_PRETTY_PRINT);
                    }
                    $stmt->close(); // Close the statement

                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

        // this to delete an item from the database
    case 'DELETE':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $userId = $path[5];

                    // Retrieve the image file name from the database
                    $stmt = $db_connect->prepare("SELECT image FROM admin_user WHERE id = ?");
                    $stmt->bind_param("s", $userId);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $row = $result->fetch_assoc();

                    if ($row) {
                        $imageToDelete = $row['image'];
                        $imagePath = $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles/' . $imageToDelete;

                        // Check if imagePath is a valid file before attempting to delete
                        if (!empty($imageToDelete) && file_exists($imagePath) && is_file($imagePath)) {
                            unlink($imagePath);
                        }
                    }

                    $stmt = $db_connect->prepare("DELETE FROM admin_user WHERE id = ?");
                    $stmt->bind_param("i", $userId);
                    if ($stmt->execute()) {
                        http_response_code(200);
                        echo json_encode(
                            [
                                'status' => 200,
                                'success' => true,
                                'message' => 'User records and image (if present) have been deleted successfully.'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    } else {
                        http_response_code(400);
                        echo json_encode(
                            [
                                'status' => 400,
                                'error' => true,
                                'message' => 'User record could not be deleted'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }

                    $stmt->close(); // Closing the statement
                } else {
                    http_response_code(400);
                    echo json_encode(
                        [
                            'status' => 400,
                            'error' => true,
                            'message' => 'Method not allowed'
                        ],
                        JSON_PRETTY_PRINT
                    );
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }

        break;


        // this to change or edit any of the data from the database
    case 'PUT':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $Updateuserform = json_decode(file_get_contents('php://input'));
                $id = $Updateuserform->id;
                $name = $Updateuserform->name;
                $username = $Updateuserform->username;
                $email = $Updateuserform->email;

                // Update user record
                $updateUserQuery = "UPDATE admin_user SET name=?, username=?, email=? WHERE id=?";
                $stmt = $db_connect->prepare($updateUserQuery);
                $stmt->bind_param("sssi", $name, $username, $email, $id); // "ssssi" indicates four strings and one integer
                $stmt->execute();

                if ($stmt->affected_rows > 0) {
                    http_response_code(200); // OK
                    echo json_encode([
                        'status' => 200,
                        'message' => 'User record updated successfully'
                    ], JSON_PRETTY_PRINT);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode([
                        'status' => 400,
                        'error' => 'Could not update user data'
                    ], JSON_PRETTY_PRINT);
                }

                $stmt->close(); // Close the statement

            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;



        // and this to send data request to the database in the case registration
    case 'POST':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {


                $userRegistrationForm = json_decode(file_get_contents('php://input'), true);

                // Sanitize inputs
                $name = mysqli_real_escape_string($db_connect, $userRegistrationForm['name']);
                $email = mysqli_real_escape_string($db_connect, $userRegistrationForm['email']);
                $username = mysqli_real_escape_string($db_connect, $userRegistrationForm['username']);
                // $role = mysqli_real_escape_string($db_connect, $userRegistrationForm['role']);
                $password = password_hash($userRegistrationForm['password'], PASSWORD_BCRYPT);

                // Check if email already exists
                $checkEmailQuery = "SELECT COUNT(*) as emailCount FROM admin_user WHERE email = '$email'";
                $result = mysqli_query($db_connect, $checkEmailQuery);

                if ($result) {
                    $emailRow = mysqli_fetch_assoc($result);
                    $emailCount = $emailRow['emailCount'];

                    if ($emailCount > 0) {
                        http_response_code(400); // Bad Request
                        echo json_encode(
                            [
                                'status' => 400,
                                'message' => 'Email already exists',
                                'error' => true,
                            ],
                            JSON_PRETTY_PRINT
                        );
                        return; // Exit the script early
                    }
                }
                // Check if username already exists
                $checkUsernameQuery = "SELECT COUNT(*) as usernameCount FROM admin_user WHERE username = '$username'";
                $result = mysqli_query($db_connect, $checkUsernameQuery);

                if ($result) {
                    $usernameRow = mysqli_fetch_assoc($result);
                    $usernameCount = $usernameRow['usernameCount'];

                    if ($usernameCount > 0) {
                        http_response_code(400); // Bad Request
                        echo json_encode(
                            [
                                'status' => 400,
                                'message' => 'Username already exists',
                                'error' => true,
                            ],
                            JSON_PRETTY_PRINT
                        );
                        return; // Exit the script early
                    }
                }

                // Insert new user
                $insertUserQuery = "INSERT INTO admin_user (name, username, email, password) 
                    VALUES ('$name', '$username', '$email', '$password')";
                if (mysqli_query($db_connect, $insertUserQuery)) {
                    // Fetch the inserted user
                    $sql = "SELECT * FROM admin_user WHERE email = '$email'";
                    $result = mysqli_query($db_connect, $sql);

                    if ($result && mysqli_num_rows($result) > 0) {
                        $user = mysqli_fetch_assoc($result);
                        $temp_token = $user['temp_token'];

                        // JWT Payload
                        $secretKey = 'Ukraft_african_craft_store'; // Use the same secret key
                        $algorithm = 'HS256';

                        $payload = [
                            'iss' => 'ukraft',
                            'aud' => 'ukraft',
                            'iat' => time(),
                            'nbf' => time(),
                            'exp' => time() + (60 * 60), // Token expires in 1 hour
                            'userId' => $user['id'],
                            'email' => $user['email']
                        ];

                        // Encode the JWT
                        $jwt = JWT::encode($payload, $secretKey, $algorithm);

                        // Store the token in the database
                        $updateTokenSql = "UPDATE admin_user SET token='$jwt' WHERE email='$email'";
                        mysqli_query($db_connect, $updateTokenSql);

                        // Success response
                        header('Content-Type: application/json');
                        echo json_encode(
                            [
                                'status' => 201,
                                'success' => true,
                                'message' => 'User added successfully',
                            ],
                            JSON_PRETTY_PRINT
                        );
                        return;
                    } else {
                        http_response_code(451); // Not working
                        echo json_encode(
                            [
                                'status' => 451,
                                'message' => 'Could not retrieve user data after insertion',
                                'error' => true,
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }
                } else {
                    http_response_code(500); // Internal Server Error
                    echo json_encode([
                        'status' => 500,
                        'error' => true,
                        'message' => 'Failed to insert user. Invalid format or database issue.',
                    ], JSON_PRETTY_PRINT);
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;



    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}