<?php
include "db_connect.php";
$method = $_SERVER['REQUEST_METHOD'];
function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
$baseURLProfile = "https://ukraftstoreapi.online/ukraft/api/images/profiles/";

switch ($method) {
    case 'GET':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $id = $path[5];
                    $json_array = array();
                    $stmt = $db_connect->prepare("SELECT * FROM admin_user WHERE id = ?");
                    $stmt->bind_param("i", $id); // "s" indicates the variable type is string
                    $stmt->execute();
                    $result = $stmt->get_result();

                    while ($usersRow = $result->fetch_assoc()) {
                        $imageUrlProfile = $usersRow['image'];
                        $fullProfile = $imageUrlProfile ? $baseURLProfile . $imageUrlProfile : "";
                        $json_array['users'] = array(
                            'id' => $usersRow['id'],
                            'name' => $usersRow['name'],
                            'username' => $usersRow['username'],
                            'email' => $usersRow['email'],
                            'phone' => $usersRow['phone'],
                            'getImage' => $fullProfile,
                            'homeaddress' => $usersRow['homeaddress'],
                        );

                        echo json_encode($json_array['users']);
                        return;
                    }

                    $stmt->close();
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'PUT':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {

                $Updateuserform = json_decode(file_get_contents('php://input'));
                $id = $Updateuserform->id;
                $name = $Updateuserform->name;
                $username = $Updateuserform->username;
                $email = $Updateuserform->email;
                $phone = $Updateuserform->phone;
                $homeAddress = $Updateuserform->homeaddress;

                $updateUserQuery = "UPDATE admin_user SET name=?, username=?, email=?, phone=?, homeaddress=? WHERE id=?";
                $stmt = $db_connect->prepare($updateUserQuery);
                $stmt->bind_param("sssssi", $name, $username, $email, $phone, $homeAddress, $id); // "ssssi" indicates four strings and one integer
                $stmt->execute();

                if ($stmt->affected_rows > 0) {
                    http_response_code(200); // OK
                    echo json_encode([
                        'status' => 200,
                        'message' => 'User record updated successfully'
                    ], JSON_PRETTY_PRINT);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode([
                        'status' => 400,
                        'error' => 'Could not update user data'
                    ], JSON_PRETTY_PRINT);
                }

                $stmt->close(); // Close the statement

            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }

        break;


    case 'POST':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $id = $path[5];
                    $get_file = $_FILES['photo'];
                    if ($get_file) {
                        $file = time() . $_FILES['photo']['name'];
                        $file_temp = $_FILES['photo']['tmp_name'];
                        $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles' . "/" . $file;

                        // get the already posted image from db
                        $stmt = $db_connect->prepare("SELECT image FROM admin_user WHERE id = ?");
                        $stmt->bind_param("s", $id);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        $row = $result->fetch_assoc();
                        $imageToDelete = $row['image'];
                        $imagePath = $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles' . "/" . $imageToDelete;
                        if (file_exists($imagePath)) {
                            unlink($imagePath);
                        }
                        // update user image
                        $updateUserQuery = "UPDATE admin_user SET image=? WHERE id=?";
                        $stmt = $db_connect->prepare($updateUserQuery);
                        $stmt->bind_param("si", $file, $id); // "si" indicates 1 strings and one integer
                        $stmt->execute();
                        if ($stmt->execute()) {
                            move_uploaded_file($file_temp, $destination);
                            http_response_code(200); // not working
                            echo json_encode(
                                [
                                    'status' => 200,
                                    'message' => 'image has been uploaded successfully'
                                ],
                                JSON_PRETTY_PRINT
                            );
                        } else {
                            http_response_code(451); // not working
                            echo json_encode(
                                [
                                    'status' => 451,
                                    'error' => 'Could not upload the image successfully'
                                ],
                                JSON_PRETTY_PRINT
                            );
                        }
                    } else {
                        http_response_code(451); // not working
                        echo json_encode(
                            [
                                'status' => 451,
                                'error' => 'didnt get the image from client side.'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }
                } else {
                    http_response_code(451); // not working
                    echo json_encode(
                        [
                            'status' => 451,
                            'error' => 'id not found'
                        ],
                        JSON_PRETTY_PRINT
                    );
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'DELETE';
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $userId = $path[5];

                    // Retrieve the image file name from the database
                    $stmt = $db_connect->prepare("SELECT image FROM admin_user WHERE id = ?");
                    $stmt->bind_param("s", $userId);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $row = $result->fetch_assoc();

                    if ($row) {
                        $imageToDelete = $row['image'];
                        $imagePath = $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/profiles' . "/" . $imageToDelete;

                        // Delete the image file from the server's file system
                        if (file_exists($imagePath)) {
                            unlink($imagePath);

                            $stmt = $db_connect->prepare("UPDATE admin_user SET image=NULL WHERE id=?");
                            $stmt->bind_param("s", $userId); // "s" indicates the variable type is string
                            if ($stmt->execute()) {
                                http_response_code(200); // OK
                                echo json_encode(
                                    [
                                        'status' => 200,
                                        'message' => 'User image has been deleted successfully.'
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                            } else {
                                http_response_code(400); // Bad Request
                                echo json_encode(
                                    [
                                        'status' => 400,
                                        'error' => 'User image could not be deleted'
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                            }
                        }
                    }
                    $stmt->close(); // Closing the statement
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode(
                        [
                            'status' => 400,
                            'error' => 'Method not allowed'
                        ],
                        JSON_PRETTY_PRINT
                    );
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }

        break;

    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}