<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $productId = $path[5];

                    $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
                    $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/"; // Adjust this URL to match your actual image directory

                    $query = "SELECT 
        products.id AS product_id,
        products.name AS product_name,
        products.description AS product_description,
        products.price AS product_price,
        products.USD_price,
        products.slashed_price,
        products.category,
        products.filter_category,
        products.sku,
        products.stock,
         products.color,
        products.weight,
        products.brand,
        products.availability,
        products.is_featured,
        products.is_top_rated,
        products.is_new_arrival,
        products.is_best_seller,
        products.total_rating,
        products.sales_count,
        products.created_at,
        products.updated_at,
        (
            SELECT GROUP_CONCAT(product_images.image_url SEPARATOR ', ')
            FROM product_images
            WHERE product_images.product_id = products.id
        ) AS product_images,
        COALESCE(
            GROUP_CONCAT(DISTINCT CONCAT_WS(':', 
                product_variations.attribute_name, 
                product_variations.attribute_value, 
                'Price', product_variations.price, 
                'Stock', product_variations.stock
            ) SEPARATOR '|'),
            'No variations available'
        ) AS variations,
        product_discounts.discount_percentage,
        product_discounts.valid_from AS start_at,
        product_discounts.valid_until AS end_at,
        product_reviews.rating AS ratings,
        product_reviews.review AS review_text,
        product_reviews.signup_id AS customer_review_id,
        flash_sales.sale_price,
        flash_sales.start_date,
        flash_sales.end_date
    FROM products
    LEFT JOIN product_images ON products.id = product_images.product_id
    LEFT JOIN product_reviews ON products.id = product_reviews.product_id
    LEFT JOIN product_variations ON products.id = product_variations.product_id
    LEFT JOIN product_discounts ON products.id = product_discounts.product_id
    LEFT JOIN flash_sales ON products.id = flash_sales.product_id
    WHERE products.id = ?";

                    $stmt = $db_store->prepare($query);
                    $stmt->bind_param("i", $productId);
                    $stmt->execute();
                    $result = $stmt->get_result();

                    if ($result->num_rows > 0) {
                        $json_array['product_details'] = [];
                        while ($row = $result->fetch_assoc()) {
                            // Process image URLs
                            $imagePaths = explode(', ', $row['product_images']);
                            $fullImageURLs = array_map(function ($imagePath) use ($baseURL) {
                                return $baseURL . $imagePath;
                            }, $imagePaths);

                            $json_array['product_details'][] = array(
                                'product_id' => $row['product_id'],
                                'product_name' => $row['product_name'],
                                'product_description' => $row['product_description'],
                                'product_price' => $row['product_price'],
                                'product_USD_price' => $row['USD_price'],
                                'slashed_price' => $row['slashed_price'],
                                'category' => $row['category'],
                                'filter_category' => $row['filter_category'],
                                'sku' => $row['sku'],
                                'stock' => $row['stock'],
                                'color' => $row['color'],
                                'weight' => $row['weight'],
                                'brand' => $row['brand'],
                                'availability' => $row['availability'],
                                'is_featured' => $row['is_featured'],
                                'is_top_rated' => $row['is_top_rated'],
                                'is_new_arrival' => $row['is_new_arrival'],
                                'is_best_seller' => $row['is_best_seller'],
                                'total_rating' => $row['total_rating'],
                                'sales_count' => $row['sales_count'],
                                'ratings' => $row['ratings'],
                                'review_text' => $row['review_text'],
                                'customer_review_id' => $row['customer_review_id'],
                                'product_images' => $fullImageURLs, // Use the full URLs array
                                'variations' => $row['variations'],
                                'sale_price' => $row['sale_price'],
                                'start_date' => $row['start_date'],
                                'end_date' => $row['end_date'],
                                'discount_percentage' => $row['discount_percentage'],
                                'start_at' => $row['start_at'],
                                'end_at' => $row['end_at'],
                                'created_at' => $row['created_at'],
                                'updated_at' => $row['updated_at'],
                            );
                        }

                        // Prepare the JSON response
                        $response = [
                            'status' => 200,
                            'success' => true,
                            'message' => $json_array['product_details']
                        ];

                        http_response_code(200); // OK
                        echo json_encode($response, JSON_PRETTY_PRINT);
                        return;
                    } else {
                        echo json_encode([
                            'status' => 404,
                            'error' => true,
                            'message' => 'No product items found.'
                        ], JSON_PRETTY_PRINT);
                    }
                } else {
                    // Destination and base URL for images
                    $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
                    $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";

                    // Get `offset` and `limit` from the request parameters (default values if not provided)
                    $offset = isset($_GET['offset']) && is_numeric($_GET['offset']) ? intval($_GET['offset']) : 0;
                    $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? intval($_GET['limit']) : 10;

                    // SQL query to get the products with pagination
                    $query = "SELECT 
    products.id AS product_id,
    products.name AS product_name,
    products.price AS product_price,
    products.USD_price,
    products.slashed_price,
    products.is_featured,
    products.category,
    products.color,
    products.weight,
    products.brand,
    products.availability,
    products.filter_category,
    products.is_top_rated,
    products.is_new_arrival,
    products.is_best_seller,
    products.total_rating,
    products.created_at,
    products.updated_at,
    (
        SELECT product_images.image_url 
        FROM product_images 
        WHERE product_images.product_id = products.id
        AND product_images.is_primary = 1
        LIMIT 1
    ) AS product_images,
    ROUND(AVG(product_reviews.rating), 1) AS ratings
FROM products
LEFT JOIN product_reviews ON products.id = product_reviews.product_id 
GROUP BY products.id
ORDER BY products.id DESC -- Ensures new products appear at the top
LIMIT ? OFFSET ?;
";

                    // Prepare and execute the product query
                    $stmt = $db_store->prepare($query);
                    $stmt->bind_param("ii", $limit, $offset); // Bind limit and offset
                    $stmt->execute();
                    $result = $stmt->get_result();

                    // Check if there are any products in the result
                    if ($result->num_rows > 0) {
                        $json_array['product_listing'] = [];
                        while ($row = $result->fetch_assoc()) {
                            // Process the image URL to prepend the base URL
                            $imageUrl = $row['product_images'];
                            $fullImageUrl = $imageUrl ? $baseURL . $imageUrl : null; // Combine the base URL with the image filename

                            // Add product details to the response array
                            $json_array['product_listing'][] = array(
                                'product_id' => $row['product_id'],
                                'product_name' => $row['product_name'],
                                'product_price' => $row['product_price'],
                                'product_USD_price' => $row['USD_price'],
                                'slashed_price' => $row['slashed_price'],
                                'is_featured' => $row['is_featured'],
                                'category' => $row['category'],
                                'color' => $row['color'],
                                'weight' => $row['weight'],
                                'brand' => $row['brand'],
                                'availability' => $row['availability'],
                                'filter_category' => $row['filter_category'],
                                'is_top_rated' => $row['is_top_rated'],
                                'is_new_arrival' => $row['is_new_arrival'],
                                'is_best_seller' => $row['is_best_seller'],
                                'total_rating' => $row['total_rating'],
                                'ratings' => $row['ratings'],
                                'product_images' => $fullImageUrl, // Use the full image URL
                                'created_at' => $row['created_at'],
                                'updated_at' => $row['updated_at'],
                            );
                        }

                        // Prepare the JSON response, including the total count of products
                        $response = [
                            'status' => 200,
                            'success' => true,
                            'message' => $json_array['product_listing'],
                            'pagination' => [
                                'offset' => $offset,
                                'limit' => $limit
                            ]
                        ];

                        http_response_code(200); // OK
                        echo json_encode($response, JSON_PRETTY_PRINT);
                        return;
                    } else {
                        echo json_encode([
                            'status' => 404,
                            'error' => true,
                            'message' => 'No product items found.'
                        ], JSON_PRETTY_PRINT);
                    }
                    $stmt->close();
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'POST':
        if ($token) {
            // Update product reviews
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                try {

                    $path = explode('/', $_SERVER["REQUEST_URI"]);
                    if (isset($path[5]) && is_numeric($path[5])) {
                        $productId = $path[5];

                        // Sanitize inputs to prevent SQL injection
                        $product_name = isset($_POST['product_name']) ? mysqli_real_escape_string($db_store, $_POST['product_name']) : null;
                        $description = isset($_POST['description']) ? mysqli_real_escape_string($db_store, $_POST['description']) : null;
                        $product_price = isset($_POST['product_price']) ? floatval($_POST['product_price']) : null;
                        $slashed_price = isset($_POST['slashed_price']) ? floatval($_POST['slashed_price']) : null;
                        $category = isset($_POST['category']) ? mysqli_real_escape_string($db_store, $_POST['category']) : null;
                        $filter_category = isset($_POST['filter_category']) ? mysqli_real_escape_string($db_store, $_POST['filter_category']) : null;
                        $color = isset($_POST['color']) ? mysqli_real_escape_string($db_store, $_POST['color']) : null;
                        $weight = isset($_POST['weight']) ? mysqli_real_escape_string($db_store, $_POST['weight']) : null;
                        $brand = isset($_POST['brand']) ? mysqli_real_escape_string($db_store, $_POST['brand']) : null;
                        $sku = isset($_POST['sku']) ? mysqli_real_escape_string($db_store, $_POST['sku']) : null;
                        $stock = isset($_POST['stock']) ? intval($_POST['stock']) : null;
                        $availability = isset($_POST['availability']) ? mysqli_real_escape_string($db_store, $_POST['availability']) : null;
                        $is_featured = isset($_POST['is_featured']) ? intval($_POST['is_featured']) : null;
                        $is_top_rated = isset($_POST['is_top_rated']) ? intval($_POST['is_top_rated']) : null;
                        $is_new_arrival = isset($_POST['is_new_arrival']) ? intval($_POST['is_new_arrival']) : null;
                        $is_best_seller = isset($_POST['is_best_seller']) ? intval($_POST['is_best_seller']) : null;
                        $total_rating = isset($_POST['total_rating']) ? intval($_POST['total_rating']) : null;
                        $sales_count = isset($_POST['sales_count']) ? intval($_POST['sales_count']) : null;

                        // Update the `products` table
                        $update_query = "UPDATE products SET 
        name = '$product_name', 
        description = '$description', 
        price = '$product_price', 
        slashed_price = '$slashed_price', 
        category = '$category', 
        filter_category = '$filter_category', 
        color = '$color', 
        weight = '$weight', 
        brand = '$brand', 
        sku = '$sku', 
        stock = '$stock', 
        availability = '$availability', 
        is_featured = '$is_featured', 
        is_top_rated = '$is_top_rated', 
        is_new_arrival = '$is_new_arrival', 
        is_best_seller = '$is_best_seller', 
        total_rating = '$total_rating', 
        sales_count = '$sales_count' 
        WHERE id = '$productId'";

                        if (mysqli_query($db_store, $update_query)) {
                            $ratings = isset($_POST['ratings']) ? intval($_POST['ratings']) : null;
                            $ratings_text = null; // Placeholder for future review text

                            $review_query = "UPDATE product_reviews SET rating = '$ratings', review = '$ratings_text' WHERE product_id = '$productId'";
                            mysqli_query($db_store, $review_query);

                            // Handle product images
                            $product_images = isset($_FILES['product_images']) ? $_FILES['product_images'] : null;

                            if ($product_images && isset($product_images['name']) && is_array($product_images['name'])) {
                                // New images uploaded: delete old images and replace them
                                $image_query = "SELECT image_url FROM product_images WHERE product_id = '$productId';";
                                $result = mysqli_query($db_store, $image_query);

                                while ($row = mysqli_fetch_assoc($result)) {
                                    $imageToDelete = $row['image_url'];
                                    $imagePath = $_SERVER['DOCUMENT_ROOT'] . "/ukraft/api/images/products/" . $imageToDelete;

                                    if (file_exists($imagePath)) {
                                        unlink($imagePath); // Delete the file from the server
                                    }
                                }

                                // Delete images from the database
                                $delete_query = "DELETE FROM product_images WHERE product_id = '$productId'";
                                mysqli_query($db_store, $delete_query);

                                // Add new images
                                $image_dir = $_SERVER['DOCUMENT_ROOT'] . "/ukraft/api/images/products/";
                                for ($i = 0; $i < count($product_images['name']); $i++) {
                                    if ($product_images['error'][$i] === UPLOAD_ERR_OK) {
                                        $image_name = time() . "_" . basename($product_images['name'][$i]);
                                        $target_file = $image_dir . $image_name;
                                        $is_primary = ($i === 0) ? 1 : 0;

                                        if (move_uploaded_file($product_images['tmp_name'][$i], $target_file)) {
                                            $add_image_query = "INSERT INTO product_images (product_id, image_url, is_primary) VALUES ('$productId', '$image_name', '$is_primary');";
                                            mysqli_query($db_store, $add_image_query);
                                        } else {
                                            throw new Exception("Error uploading image: $image_name");
                                        }
                                    } else {
                                        throw new Exception("File upload error for image index $i.");
                                    }
                                }
                            } else {
                                // No new images uploaded: keep existing images
                                $image_query = "SELECT image_url, is_primary FROM product_images WHERE product_id = '$productId'";
                                $result = mysqli_query($db_store, $image_query);
                                $existing_images = [];

                                while ($row = mysqli_fetch_assoc($result)) {
                                    $existing_images[] = [
                                        'image_url' => "https://ukraftstoreapi.online/ukraft/api/images/products/" . $row['image_url'],
                                        'is_primary' => $row['is_primary'],
                                    ];
                                }

                                http_response_code(200);
                                echo json_encode([
                                    'status' => 200,
                                    'success' => true,
                                    'message' => "Product updated successfully.",
                                    'images' => $existing_images
                                ], JSON_PRETTY_PRINT);
                                exit;
                            }

                            http_response_code(200);
                            echo json_encode([
                                'status' => 200,
                                'success' => true,
                                'message' => "Product updated successfully."
                            ], JSON_PRETTY_PRINT);
                        } else {
                            http_response_code(400);
                            echo json_encode([
                                'status' => 400,
                                'error' => true,
                                'message' => "Failed to update product details."
                            ], JSON_PRETTY_PRINT);
                        }
                    } else {
                        // Collect product details from the form
                        $product_name = $_POST['product_name'];
                        $description = $_POST['description'];
                        $product_price = $_POST['product_price'];
                        $slashed_price = $_POST['slashed_price'];
                        $category = $_POST['category'];
                        $filter_category = $_POST['filter_category'];
                        $color = $_POST['color'];
                        $weight = $_POST['weight'];
                        $brand = $_POST['brand'];
                        $sku = $_POST['sku'];
                        $stock = $_POST['stock'];
                        $availability = $_POST['availability'];
                        $is_featured = $_POST['is_featured'];
                        $is_top_rated = $_POST['is_top_rated'];
                        $is_new_arrival = $_POST['is_new_arrival'];
                        $is_best_seller = $_POST['is_best_seller'];
                        $total_rating = $_POST['total_rating'];
                        $sale_count = $_POST['sales_count'];

                        // Insert data into the `products` table
                        $product_query = "INSERT INTO products (name, description, price, slashed_price, category, filter_category, color, weight, brand, sku, stock, availability, is_featured, is_top_rated, is_new_arrival, is_best_seller, total_rating, sales_count) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";

                        $stmt = $db_store->prepare($product_query);
                        $stmt->bind_param("ssddssssssissssiii", $product_name, $description, $product_price, $slashed_price, $category, $filter_category, $color, $weight, $brand, $sku, $stock, $availability, $is_featured, $is_top_rated, $is_new_arrival, $is_best_seller, $total_rating, $sale_count);

                        if ($stmt->execute()) {
                            // Get the generated product ID
                            $product_id = $db_store->insert_id;



                            // Handle product images upload
                            $product_images = isset($_FILES['product_images']) ? $_FILES['product_images'] : null;

                            if ($product_images && isset($product_images['name']) && is_array($product_images['name'])) {
                                $stmt = $db_store->prepare("INSERT INTO product_images (product_id, image_url, is_primary ) VALUES (?, ?, ?)");
                                $image_dir = $_SERVER['DOCUMENT_ROOT'] . "/ukraft/api/images/products/";
                                for ($i = 0; $i < count($product_images['name']); $i++) {
                                    if ($product_images['error'][$i] === UPLOAD_ERR_OK) {
                                        $image_name = time() . "_" . basename($product_images['name'][$i]);
                                        $target_file = $image_dir . $image_name;
                                        $is_primary = ($i === 0) ? 1 : 0; // First image is primary

                                        if (move_uploaded_file($product_images['tmp_name'][$i], $target_file)) {
                                            $stmt->bind_param("isi", $product_id, $image_name, $is_primary);
                                            if (!$stmt->execute()) {
                                                throw new Exception("Error inserting into property_image table: " . $stmt->error);
                                            }
                                        } else {
                                            throw new Exception("Error uploading image: $image_name");
                                        }
                                    } else {
                                        throw new Exception("File upload error for image index $i.");
                                    }
                                }
                            }


                            // Insert ratings and reviews into `product_review` table
                            $ratings = $_POST['ratings'];
                            $ratings_text = NULL;
                            $signup_id = NULL; // Assuming this will remain NULL for now

                            $review_query = "INSERT INTO product_reviews (product_id, signup_id, rating, review) VALUES (?, ?, ?, ?);";
                            $review_stmt = $db_store->prepare($review_query);
                            $review_stmt->bind_param("iiss", $product_id, $signup_id, $ratings, $ratings_text);

                            if ($review_stmt->execute()) {
                                http_response_code(200);
                                echo json_encode(
                                    [
                                        'status' => 200,
                                        'success' => true,
                                        'message' => "Product and related data submitted successfully."
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                                // echo json_encode(["success" => true,
                                //     "message" => "Product and related data submitted successfully."
                                // ]);
                            } else {
                                http_response_code(401);
                                echo json_encode(
                                    [
                                        'status' => 401,
                                        'error' => true,
                                        'message' => "Failed to insert product review."
                                    ],
                                    JSON_PRETTY_PRINT
                                );
                                // echo json_encode(["success" => false, "message" => "Failed to insert product review."]);
                            }
                        } else {
                            http_response_code(401);
                            echo json_encode(
                                [
                                    'status' => 401,
                                    'error' => true,
                                    'message' => "Failed to insert product details."
                                ],
                                JSON_PRETTY_PRINT
                            );
                            // echo json_encode(["success" => false, "message" => "Failed to insert product details."]);
                        }
                    }
                } catch (Exception $e) {
                    http_response_code(500); // Internal Server Error
                    echo json_encode([
                        'status' => 500,
                        'error' => true,
                        'message' => 'An error occurred while processing your request.' . $e->getMessage(),
                    ]);
                } finally {
                    // Close the database connection if it's open
                    if (isset($db_store) && $db_store->ping()) {
                        $db_store->close();
                    }
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'DELETE':


        if ($token) {
            // Verify token
            $result = $db_connect->query("SELECT token FROM admin_user WHERE token = '$token'");
            if ($result->num_rows > 0) {
                try {
                    $path = explode('/', $_SERVER["REQUEST_URI"]);
                    if (isset($path[5]) && is_numeric($path[5])) {
                        $productId = $path[5];

                        // Retrieve all image file names associated with the product_id
                        $result = $db_store->query("SELECT image_url FROM product_images WHERE product_id = '$productId'");

                        $imagesDeleted = [];
                        $errors = [];

                        while ($row = $result->fetch_assoc()) {
                            $imageToDelete = $row['image_url'];
                            $imagePath = $_SERVER['DOCUMENT_ROOT'] . '/ukraft/api/images/products' . "/" . $imageToDelete;

                            // Delete the image file from the server's file system
                            if (file_exists($imagePath)) {
                                if (unlink($imagePath)) {
                                    $imagesDeleted[] = $imageToDelete;
                                } else {
                                    $errors[] = "Failed to delete image: $imageToDelete";
                                }
                            } else {
                                $errors[] = "Image not found on the server: $imageToDelete";
                            }
                        }

                        // Delete product records associated with the product_id
                        if ($db_store->query("DELETE FROM products WHERE id = '$productId'")) {
                            http_response_code(200); // OK
                            echo json_encode(
                                [
                                    'status' => 200,
                                    'success' => true,
                                    'message' => 'Product records and associated images have been deleted successfully.',
                                    'imagesDeleted' => $imagesDeleted,
                                    'errors' => $errors
                                ],
                                JSON_PRETTY_PRINT
                            );
                        } else {
                            http_response_code(400); // Bad Request
                            echo json_encode(
                                [
                                    'status' => 400,
                                    'error' => true,
                                    'message' => 'User records could not be deleted.',
                                    'errors' => $errors
                                ],
                                JSON_PRETTY_PRINT
                            );
                        }
                    } else {
                        http_response_code(400); // Bad Request
                        echo json_encode(
                            [
                                'status' => 400,
                                'error' => true,
                                'message' => 'Method not allowed or invalid product_id.'
                            ],
                            JSON_PRETTY_PRINT
                        );
                    }
                } catch (Exception $e) {
                    http_response_code(500); // Internal Server Error
                    echo json_encode([
                        'status' => 500,
                        'error' => true,
                        'message' => 'An error occurred while processing your request.' . $e->getMessage(),
                    ]);
                } finally {
                    // Close the database connection if it's open
                    if (isset($db_store) && $db_store->ping()) {
                        $db_store->close();
                    }
                }
            } else {
                // Invalid token
                http_response_code(401); // Unauthorized
                echo json_encode([
                    'status' => 401,
                    'error' => true,
                    'message' => 'Invalid token.'
                ]);
            }
        } else {
            // No token provided
            http_response_code(400); // Bad Request
            echo json_encode([
                'status' => 400,
                'error' => true,
                'message' => 'Authorization token missing.'
            ]);
        }

        break;



    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}