<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();

$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
    case 'GET':
        if (isset($token)) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];

                $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";
                $path = explode('/', $_SERVER["REQUEST_URI"]);
                if (isset($path[5]) && is_numeric($path[5])) {
                    $order_id = $path[5];
                    if ($order_id) {
                        $orderData = [];

                        // Get order details
                        $stmt = $db_store->prepare("SELECT * FROM orders WHERE id = ?");
                        $stmt->bind_param("i", $order_id);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        if ($result->num_rows > 0) {
                            $orderData = $result->fetch_assoc();
                            $signup_id = $orderData['signup_id'];
                            $orderData['items'] = [];

                            // Billing address for order details
                            $query = "SELECT
                billing_address.id AS billing_address_id,
                billing_address.firstname AS billing_address_firstname,
                billing_address.lastname AS billing_address_lastname,
                billing_address.email AS billing_address_email,
                billing_address.phone AS billing_address_phone,
                billing_address.address AS billing_address_address,
                billing_address.city AS billing_address_city,
                billing_address.state AS billing_address_state,
                billing_address.country AS billing_address_country,
                billing_address.zip_code AS billing_address_zip
            FROM billing_address
            WHERE billing_address.signup_id = ?";

                            $stmt = $db_store->prepare($query);
                            $stmt->bind_param("i", $signup_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($billing_address = $result->fetch_assoc()) {
                                $orderData['billing_address'][] = $billing_address;
                            }

                            // Shipping address for order details
                            $query = "SELECT
                shipping_address.id AS shipping_address_id,
                shipping_address.firstname AS shipping_address_firstname,
                shipping_address.lastname AS shipping_address_lastname,
                shipping_address.email AS shipping_address_email,
                shipping_address.phone AS shipping_address_phone,
                shipping_address.address AS shipping_address_address,
                shipping_address.city AS shipping_address_city,
                shipping_address.state AS shipping_address_state,
                shipping_address.country AS shipping_address_country,
                shipping_address.zip_code AS shipping_address_zip
            FROM shipping_address
            WHERE shipping_address.signup_id = ?";

                            $stmt = $db_store->prepare($query);
                            $stmt->bind_param("i", $signup_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($shipping_address = $result->fetch_assoc()) {
                                $orderData['shipping_address'][] = $shipping_address;
                            }

                            // Define the base URL for images
                            $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/";

                            // Order individual items for order details
                            $query = "SELECT order_items.order_id, order_items.product_id, 
                order_items.quantity AS orders_quantity,
                order_items.price AS order_price,
                order_items.created_at AS order_item_time,
                products.name AS product_name,
                products.description AS product_description,
                products.price AS product_price,
                product_images.image_url AS product_image
                FROM order_items
                LEFT JOIN products ON order_items.product_id = products.id
                LEFT JOIN product_images ON product_images.product_id = products.id AND product_images.is_primary = 1
                WHERE order_items.order_id = ?";

                            $stmt = $db_store->prepare($query);
                            $stmt->bind_param("i", $order_id);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            while ($item = $result->fetch_assoc()) {
                                // Combine base URL with image filename to create full image URL
                                $item['product_image'] = $item['product_image'] ? $baseURL . $item['product_image'] : null;
                                $orderData['items'][] = $item;
                            }

                            echo json_encode([
                                'status' => 200,
                                'success' => true,
                                'message' => $orderData
                            ], JSON_PRETTY_PRINT);
                        } else {
                            echo json_encode([
                                'status' => 400,
                                'error' => true,
                                'message' => 'No order found.'
                            ], JSON_PRETTY_PRINT);
                        }
                    } else {
                        echo json_encode([
                            'status' => 400,
                            'error' => true,
                            'message' => 'Invalid order id.'
                        ], JSON_PRETTY_PRINT);
                    }
                } else {
                    $offset = isset($_GET['offset']) && is_numeric($_GET['offset']) ? intval($_GET['offset']) : 0;
                    $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? intval($_GET['limit']) : 10;

                    $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
                    $stmt = $db_store->prepare("SELECT * FROM orders ORDER BY id DESC LIMIT ? OFFSET ?");
                    $stmt->bind_param('ii', $limit, $offset);
                    $stmt->execute(); // Execute the prepared statement
                    $result = $stmt->get_result(); // Get the result object
                    if ($result->num_rows > 0) {
                        $json_array['orders'] = [];
                        while ($row = $result->fetch_assoc()) {
                            $json_array['orders'][] = array(
                                'id' => $row['id'],
                                'total_amount' => $row['total_amount'],
                                'status' => $row['status'],
                                'order_progress' => $row['order_progress'],
                                'order_note' => $row['order_note'],
                                'timestamp' => $row['created_at']
                            );
                        }
                        // Prepare the JSON response
                        $response = [
                            'status' => 200,
                            'success' => true,
                            'message' =>  $json_array['orders']
                        ];

                        http_response_code(200); // OK
                        echo json_encode($response, JSON_PRETTY_PRINT);
                        return;
                    } else {
                        echo json_encode([
                            'status' => 404,
                            'error' => true,
                            'message' => 'No orders found.'
                        ], JSON_PRETTY_PRINT);
                    }
                    $stmt->close(); // Close the statement


                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    case 'PUT':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Decode the JSON input
                $UpdateOrderProgress = json_decode(file_get_contents('php://input'));

                // Sanitize and validate inputs
                $id = isset($UpdateOrderProgress->order_id) ? intval($UpdateOrderProgress->order_id) : null;
                $order_progress = isset($UpdateOrderProgress->order_progress)
                    ? mysqli_real_escape_string($db_store, $UpdateOrderProgress->order_progress)
                    : null;

                // Check if required inputs are valid
                if (!$id || !$order_progress) {
                    http_response_code(400); // Bad Request
                    echo json_encode([
                        'status' => 400,
                        'error' => 'error',
                        'message' => 'Invalid input data.',
                    ], JSON_PRETTY_PRINT);
                    exit;
                }

                // Build the update query
                $updateOrderQuery = "UPDATE orders SET order_progress = '$order_progress' WHERE id = $id";

                // Execute the query
                $result = mysqli_query($db_store, $updateOrderQuery);

                // Check the result
                if ($result && mysqli_affected_rows($db_store) > 0) {
                    http_response_code(200); // OK
                    echo json_encode([
                        'status' => 200,
                        'success' => 'success',
                        'message' => 'Order progress updated successfully',
                    ], JSON_PRETTY_PRINT);
                } else {
                    http_response_code(400); // Bad Request
                    echo json_encode([
                        'status' => 400,
                        'error' => 'error',
                        'message' => 'Could not update order progress.',
                    ], JSON_PRETTY_PRINT);
                }

                // Close the database connection
                mysqli_close($db_store);
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode(
            [
                'status' => 405,
                'error' => true,
                'message' => 'Method not allowed.'
            ],
            JSON_PRETTY_PRINT
        );
}