<?php
include  "db_connect.php";


function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
$method = $_SERVER['REQUEST_METHOD'];
switch ($method) {
    case 'POST':
        $changePassword = json_decode(file_get_contents('php://input'));
        $password = $changePassword->password;
        $token = $changePassword->token;
        $error = "Could not connect to the database";

        // // Check if the input data is valid
        if (isset($password) && isset($token)) {
            $password_hash = password_hash($password, PASSWORD_DEFAULT);

            if (!empty($token)) {
                if (!empty($password_hash)) {
                    // this to check if token is curresponding with the one in the database
                    $check_token = "SELECT * FROM admin_user WHERE temp_token = ? LIMIT 1 ";
                    $stmt = $db_connect->prepare($check_token);
                    $stmt->bind_param('s', $token);
                    $stmt->execute();
                    $result = $stmt->get_result();

                    if ($result && $result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        $get_email = $row['email'];
                        // get the db time
                        $get_db_timer = strtotime($row['temp_token_validation']);
                        // get the current time
                        $current_Time = time();
                        // calculate the time different
                        $timeDiffent = $get_db_timer - $current_Time;

                        if ($timeDiffent >= 1800) {
                            http_response_code(400); // Bad Request
                            echo json_encode([
                                'status' => 400,
                                'error' => true,
                                'message' => 'Your token has expired!',
                            ], JSON_PRETTY_PRINT);
                            die();
                        } else {
                            if ($password_hash) {
                                $update_password = "UPDATE admin_user SET password = ?, temp_token = NULL, temp_token_validation = NULL WHERE email = ? LIMIT 1";
                                $stmt = $db_connect->prepare($update_password);
                                $stmt->bind_param('ss', $password_hash, $get_email);

                                if ($stmt->execute() === TRUE) {
                                    echo json_encode([
                                        'status' => 200,
                                        'success' => true,
                                        'message' => 'Password has been updated successfully,',
                                    ], JSON_PRETTY_PRINT);
                                } else {
                                    http_response_code(400); // Bad Request
                                    echo json_encode([
                                        'status' => 400,
                                        'message' => 'Could not update password',
                                        'error' => true,
                                    ], JSON_PRETTY_PRINT);
                                }
                            }
                        }
                    } else {
                        http_response_code(404); // not found
                        echo json_encode([
                            'status' => 404,
                            'error' => true,
                            'message' => 'Invalid token',
                        ], JSON_PRETTY_PRINT);
                    }

                    // echo json_encode(["success:" => "successful intake"]);
                } else {
                    echo json_encode(["errorMsg" => "Token or input field is undefined"]);
                }
            } else {
                echo json_encode(["errorsMsg" => "Token is not recognised"]);
            }
        }
        break;


    default:
        # code...
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}


    // }
// }