<?php
include "db_connect.php";

function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        $path = explode('/', $_SERVER["REQUEST_URI"]);
        if (isset($path[4]) && is_numeric($path[4])) {
            $productId = $path[4];

            $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
            $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/"; // Adjust this URL to match your actual image directory

            $query = "SELECT 
        products.id AS product_id,
        products.name AS product_name,
        products.description AS product_description,
        products.price AS product_price,
        products.USD_price,
        products.slashed_price,
        products.category,
        products.filter_category,
        products.sku,
        products.stock,
         products.color,
        products.weight,
        products.brand,
        products.availability,
        products.is_featured,
        products.is_top_rated,
        products.is_new_arrival,
        products.is_best_seller,
        products.total_rating,
        products.sales_count,
        products.created_at,
        products.updated_at,
        (
            SELECT product_images.image_url 
            FROM product_images 
            WHERE product_images.product_id = products.id
            AND product_images.is_primary = 1
        ) AS product_images,
        COALESCE(
            GROUP_CONCAT(DISTINCT CONCAT_WS(':', 
                product_variations.attribute_name, 
                product_variations.attribute_value, 
                'Price', product_variations.price, 
                'Stock', product_variations.stock
            ) SEPARATOR '|'),
            'No variations available'
        ) AS variations,
        product_discounts.discount_percentage,
        product_discounts.valid_from AS start_at,
        product_discounts.valid_until AS end_at,
        product_reviews.rating AS ratings,
        product_reviews.review AS review_text,
        product_reviews.signup_id AS customer_review_id,
        flash_sales.sale_price,
        flash_sales.start_date,
        flash_sales.end_date
    FROM products
    LEFT JOIN product_images ON products.id = product_images.product_id
    LEFT JOIN product_reviews ON products.id = product_reviews.product_id
    LEFT JOIN product_variations ON products.id = product_variations.product_id
    LEFT JOIN product_discounts ON products.id = product_discounts.product_id
    LEFT JOIN flash_sales ON products.id = flash_sales.product_id
    WHERE products.id = ?";

            $stmt = $db_connect->prepare($query);
            $stmt->bind_param("i", $productId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $json_array['topRated'] = [];
                while ($row = $result->fetch_assoc()) {
                    // Process image URLs
                    $imageUrl = $row['product_images'];
                    if ($imageUrl) {
                        $fullImageUrl = $baseURL . $imageUrl; // Combine the base URL with the image filename
                    } else {
                        $fullImageUrl = null; // No image found
                    }

                    $json_array['topRated'][] = array(
                        'product_id' => $row['product_id'],
                        'product_name' => $row['product_name'],
                        'product_description' => $row['product_description'],
                        'product_price' => $row['product_price'],
                        'product_USD_price' => $row['USD_price'],
                        'slashed_price' => $row['slashed_price'],
                        'category' => $row['category'],
                        'filter_category' => $row['filter_category'],
                        'sku' => $row['sku'],
                        'stock' => $row['stock'],
                        'color' => $row['color'],
                        'weight' => $row['weight'],
                        'brand' => $row['brand'],
                        'availability' => $row['availability'],
                        'is_featured' => $row['is_featured'],
                        'is_top_rated' => $row['is_top_rated'],
                        'is_new_arrival' => $row['is_new_arrival'],
                        'is_best_seller' => $row['is_best_seller'],
                        'total_rating' => $row['total_rating'],
                        'sales_count' => $row['sales_count'],
                        'ratings' => $row['ratings'],
                        'review_text' => $row['review_text'],
                        'customer_review_id' => $row['customer_review_id'],
                        'product_images' => $fullImageURL, // Use the full URLs array
                        'variations' => $row['variations'],
                        'sale_price' => $row['sale_price'],
                        'start_date' => $row['start_date'],
                        'end_date' => $row['end_date'],
                        'discount_percentage' => $row['discount_percentage'],
                        'start_at' => $row['start_at'],
                        'end_at' => $row['end_at'],
                        'created_at' => $row['created_at'],
                        'updated_at' => $row['updated_at'],
                    );
                }

                // Prepare the JSON response
                $response = [
                    'status' => 200,
                    'success' => true,
                    'message' =>  $json_array['topRated']
                ];

                http_response_code(200); // OK
                echo json_encode($response, JSON_PRETTY_PRINT);
                return;
            } else {
                echo json_encode([
                    'status' => 404,
                    'error' => true,
                    'message' => 'No product items found.'
                ], JSON_PRETTY_PRINT);
            }
        } else {

            $destination = $_SERVER['DOCUMENT_ROOT'] . '/ukraft' . "/";
            $baseURL = "https://ukraftstoreapi.online/ukraft/api/images/products/"; // Adjust this URL to match your actual image directory
            $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? intval($_GET['limit']) : 6; // Default to 10
            $offset = isset($_GET['offset']) && is_numeric($_GET['offset']) ? intval($_GET['offset']) : 0;
            $query = "SELECT 
            products.id AS product_id,
            products.name AS product_name,
            products.price AS product_price,
            products.USD_price,
            products.slashed_price,
            products.is_top_rated AS toprated,
            products.category,
            products.brand,
            products.filter_category,
            products.total_rating,
            products.created_at,
            products.updated_at,
            (
                SELECT product_images.image_url 
                FROM product_images 
                WHERE product_images.product_id = products.id
                AND product_images.is_primary = 1
            ) AS product_images,
            ROUND(AVG(product_reviews.rating), 1) AS ratings
          FROM products
          LEFT JOIN product_reviews 
          ON products.id = product_reviews.product_id 
          WHERE products.is_top_rated = 1
           GROUP BY products.id LIMIT ? OFFSET ?
          "; // Only topRated products

            $stmt = $db_connect->prepare($query);
            $stmt->bind_param("ii", $limit, $offset); // Bind the limit parameter
            $stmt->execute(); // Execute the prepared statement
            $result = $stmt->get_result(); // Get the result object

            if ($result->num_rows > 0) {
                $json_array['topRated'] = [];
                while ($row = $result->fetch_assoc()) {
                    // Process the image URL to prepend the base URL
                    $imageUrl = $row['product_images'];
                    $fullImageUrl = $imageUrl ? $baseURL . $imageUrl : null; // Combine the base URL with the image filename

                    $json_array['topRated'][] = array(
                        'product_id' => $row['product_id'],
                        'product_name' => $row['product_name'],
                        'product_price' => $row['product_price'],
                        'product_USD_price' => $row['USD_price'],
                        'slashed_price' => $row['slashed_price'],
                        'is_top_rated' => $row['toprated'],
                        'category' => $row['category'],
                        'brand' => $row['brand'],
                        'filter_category' => $row['filter_category'],
                        'total_rating' => $row['total_rating'],
                        'ratings' => $row['ratings'],
                        'product_images' => $fullImageUrl,
                        'created_at' => $row['created_at'],
                        'updated_at' => $row['updated_at'],
                    );
                }

                // Prepare the JSON response
                $response = [
                    'status' => 200,
                    'success' => true,
                    'message' => $json_array['topRated']
                ];

                http_response_code(200); // OK
                echo json_encode($response, JSON_PRETTY_PRINT);
                return;
            } else {
                echo json_encode([
                    'status' => 404,
                    'error' => true,
                    'message' => 'No topRated products found.'
                ], JSON_PRETTY_PRINT);
            }

            $stmt->close();
        }

        break;

    case 'POST':
        if ($token) {
            $stmt = $db_connect->prepare("SELECT token FROM signup WHERE token = ?");
            $stmt->bind_param("s", $token);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Token is valid
                $userRow = $result->fetch_assoc();
                $get_token = $userRow['token'];
                echo json_encode(
                    [
                        'status' => 200,
                        'success' => true,
                        'message' => 'Authorized'
                    ],
                    JSON_PRETTY_PRINT
                );
                // all the query code comes in here
                // $category_id = $_POST['category_id']; // Assume this is provided by the frontend
                // Alternatively, you could insert a new category like below
                $category = $_POST['category'];
                $product_name = $_POST['product_name'];
                $product_description = $_POST['product_description'];
                $product_price = $_POST['product_price'];
                $sku = $_POST['sku'];
                $stock =   $_POST['stock'];
                $availability = $_POST['availability'];
                $is_featured = $_POST['is_featured'] ? 1 : 0;
                $is_top_rated = $_POST['is_top_rated'] ? 1 : 0;
                $is_new_arrival = $_POST['is_new_arrival'] ? 1 : 0;
                $is_best_seller = $_POST['is_best_seller'] ? 1 : 0;
                $average_rating = $_POST['average_rating'];
                $sales_count = $_POST['sales_count'];
                // $product_images = $_POST['product_images'];
                // $variations = $_POST['variations'];
                // $ratings = $_POST['ratings'];
                // $review_text = $_POST['review_text'];
                // $review_count = $_POST['review_count'];
                // $discount_percentage = $_POST['discount_percentage'];
                // $discounts_start = $_POST['discounts_start'];
                // $discounts_end = $_POST['discounts_end'];
                // $sale_price = $_POST['sale_price'];
                // $start_date = $_POST['start_date'];
                // $end_date = $_POST['end_date'];
                // $product_images = $_FILES['product_images'];
                // $related_products = $_POST['related_products'];


                // Step 1: Insert into the categories table (if needed) or use an existing category ID
                // $stmt_category = $db_connect->prepare("INSERT INTO categories (name) VALUES (?)");
                // $stmt_category->bind_param("s", $category_name);
                // $stmt_category->execute();
                // $category_id = $db_connect->insert_id; // Get the new category ID


                // Step 2: Insert into the products table
                $stmt_product = $db_connect->prepare("INSERT INTO products (name, description, price, category, sku, stock, availability, is_featured, is_top_rated, is_new_arrival, is_best_seller, average_rating, sales_count) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt_product->bind_param(
                    "ssdssisiiiidi",
                    $product_name,
                    $product_description,
                    $product_price,
                    $category,
                    $sku,
                    $stock,
                    $availability,
                    $is_featured,
                    $is_top_rated,
                    $is_new_arrival,
                    $is_best_seller,
                    $average_rating,
                    $sales_count
                );
                if ($stmt_product->execute()) {
                    // Prepare the final JSON response
                    echo json_encode([
                        'status' => 200,
                        'success' => true,
                        'message' => 'Product and related data successfully inserted'
                    ], JSON_PRETTY_PRINT);
                } else {
                    // Prepare the final JSON response
                    echo json_encode([
                        'status' => 400,
                        'error' => true,
                        'message' => 'Product insertion failed'
                    ], JSON_PRETTY_PRINT);
                }
            } else {
                // Invalid token
                http_response_code(401);
                echo json_encode(
                    [
                        'status' => 401,
                        'error' => true,
                        'message' => 'Invalid token'
                    ],
                    JSON_PRETTY_PRINT
                );
            }
        } else {
            // No token provided
            http_response_code(400);
            echo json_encode(
                [
                    'status' => 400,
                    'error' => true,
                    'message' => 'Authorization token missing'
                ],
                JSON_PRETTY_PRINT
            );
        }
        break;

    default:
        // Handle other HTTP methods like POST, PUT, DELETE, etc., if necessary
        http_response_code(405); // Method Not Allowed
        echo json_encode([
            'status' => 405,
            'error' => true,
            'message' => 'Method not allowed.'
        ], JSON_PRETTY_PRINT);
        break;
}