<?php

include "db_connect.php";
include "forgot_password_mailer.php";

// Get the input data from the request body
$sendEmail = json_decode(file_get_contents('php://input'));
$email = $sendEmail->email;

// Check if the input data is valid
if (isset($email)) {
    // Sanitize the email input to prevent SQL injection
    $email = mysqli_real_escape_string($db_connect, $email);

    // Query to check if the email exists
    $query = "SELECT * FROM signup WHERE email = '$email' LIMIT 1";
    $result = mysqli_query($db_connect, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $get_email = $row['email'];
        $get_name = $row['name'];
        $get_temp_token = $row['temp_token'];
        $get_temp_token_validation = $row['temp_token_validation'];

        // Generate token and expiration
        $token = bin2hex(random_bytes(50)); // Create a random token
        $token_hash = hash('sha256', $token); // Hash the token for security
        $expiring_date = date("Y-m-d H:i:s", time() + 60 * 30); // Token valid for 30 minutes

        // Query to update the token in the database
        $sql = "UPDATE signup SET temp_token = '$token_hash', temp_token_validation = '$expiring_date' WHERE email = '$email'";
        if (mysqli_query($db_connect, $sql)) {
            header('Content-Type: application/json');
            // Send the password reset email
            send_password_reset($get_name, $get_email, $token_hash);
            echo json_encode([
                'status' => 200,
                'error' => false,
                'message' => 'Password reset mail sent successfully',
            ], JSON_PRETTY_PRINT);
        } else {
            http_response_code(400); // Bad Request
            echo json_encode([
                'status' => 400,
                'error' => true,
                'message' => 'Could not send mail',
            ], JSON_PRETTY_PRINT);
        }
    } else {
        // User record not found
        http_response_code(404); // Not Found
        echo json_encode([
            'status' => 404,
            'error' => true,
            'message' => 'User record could not be found',
        ], JSON_PRETTY_PRINT);
        exit;
    }
}
