<?php
include("db_connect.php");



function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $headers = isset($requestHeaders['Authorization']) ? trim($requestHeaders['Authorization']) : null;
    }
    return $headers;
}
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // Check if the token is present and correctly formatted (Bearer {token})
    if (!empty($headers) && preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
        return $matches[1];
    }
    return null;
}
$token = getBearerToken();
if ($token) {
    $stmt = $db_connect->prepare("SELECT token FROM admin_user WHERE token = ?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Token is valid
        $userRow = $result->fetch_assoc();
        $get_token = $userRow['token'];


        $path = explode('/', $_SERVER["REQUEST_URI"]);
        if (isset($path[5]) && is_numeric($path[5])) {
            $json_array = array();
            $userId = $path[5];
            // print_r($userId);
            // Update the status in the database
            $updateStatusSql = "UPDATE admin_user SET token=NULL WHERE id=?";
            $stmt = $db_connect->prepare($updateStatusSql);
            $stmt->bind_param("i", $userId); // Assuming 'user_id' is stored in the session
            $execute = $stmt->execute();
            if ($execute) {
                header('Content-Type: application/json');
                echo json_encode(
                    [
                        'status' => 200,
                        'success' => true,
                        'message' => 'logged out successfully'
                    ],
                    JSON_PRETTY_PRINT
                );
            } else {
                header('Content-Type: application/json');
                echo json_encode(['failed' => "did not logout successfully"]);
            }
        } else {
            // Session is not active, respond with an error
            header('Content-Type: application/json');
            echo json_encode(
                [
                    'status' => 400,
                    'false' => true,
                    'message' => 'No active token / session found'
                ],
                JSON_PRETTY_PRINT
            );
        }
    } else {
        // Invalid token
        http_response_code(401);
        echo json_encode(
            [
                'status' => 401,
                'error' => true,
                'message' => 'Invalid token'
            ],
            JSON_PRETTY_PRINT
        );
    }
} else {
    // No token provided
    http_response_code(400);
    echo json_encode(
        [
            'status' => 400,
            'error' => true,
            'message' => 'Authorization token missing'
        ],
        JSON_PRETTY_PRINT
    );
}