<?php
include("db_connect.php");
// Parse the incoming JSON payload
require  '../vendor/autoload.php';

// use Firebase\JWT\JWT;

$userLoginForm = json_decode(file_get_contents('php://input'));
$email = mysqli_real_escape_string($db_connect, $userLoginForm->email);
$password = $userLoginForm->password;

// Fetch user data
$sql = "SELECT * FROM admin_user WHERE email = '$email'";
$result = mysqli_query($db_connect, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $user = mysqli_fetch_assoc($result);

    // Verify the hash password
    if (password_verify($password, $user['password']) && $email === $user['email']) {
        $secretKey = 'Ukraft_african_craft_store'; // Use the same secret key
        $algorithm = 'HS256';

        $payload = [
            'iss' => 'ukraft',
            'aud' => 'ukraft',
            'iat' => time(),
            'nbf' => time(),
            'exp' => time() + (60 * 60), // Token expires in 1 hour
            'userId' => $user['id'],
            'email' => $user['email'],
        ];

        // Encode the JWT
        $jwt = \Firebase\JWT\JWT::encode($payload, $secretKey, $algorithm);

        // Update the token in the database
        $updateTokenSql = "UPDATE admin_user SET token = '$jwt' WHERE id = {$user['id']}";
        if (mysqli_query($db_connect, $updateTokenSql)) {
            // Fetch updated user info
            $fetchUpdatedUserSql = "SELECT id, name, username, email, role, token  FROM admin_user WHERE email = '$email'";
            $result = mysqli_query($db_connect, $fetchUpdatedUserSql);
            if ($result && mysqli_num_rows($result) > 0) {
                $userRow = mysqli_fetch_assoc($result);
                echo json_encode([
                    'status' => 200,
                    'success' => true,
                    'message' => 'Login successfully',
                    'userinfo' => [
                        'token' => $userRow['token'],
                        'user' => [
                            'userId' => $userRow['id'],
                            'name' => $userRow['name'],
                            'username' => $userRow['username'],
                            'email' => $userRow['email'],
                            'role' => $userRow['role'],
                        ]
                    ]
                ], JSON_PRETTY_PRINT);
            }
        }
    } else {
        http_response_code(400); // Bad Request
        echo json_encode([
            'status' => 400,
            'message' => 'Invalid password',
            'error' => true,
        ], JSON_PRETTY_PRINT);
    }
} else {
    http_response_code(404); // Not Found
    echo json_encode([
        'status' => 404,
        'message' => 'User Not Found',
        'error' => true,
    ], JSON_PRETTY_PRINT);
}

mysqli_close($db_connect); // Close the database connection