<?php

include "db_connect.php";
include "reset_mailer.php";

// Get the input data from the request body
$sendEmail = json_decode(file_get_contents('php://input'));
$email = $sendEmail->email;

// Check if the input data is valid
if (isset($email)) {
    $query = "SELECT * FROM admin_user WHERE email = ? LIMIT 1";
    $stmt = $db_connect->prepare($query);
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $get_email = $row['email'];
        $get_name = $row['name'];

        $token = bin2hex(random_bytes(50));
        $token_hash = hash('sha256', $token);
        $expiring_date = date("Y-m-d H:i:s", time() + 60 * 30);

        $sql = "UPDATE admin_user SET temp_token = ?, temp_token_validation = ? WHERE email = ?";
        $stmt = $db_connect->prepare($sql);
        $stmt->bind_param('sss', $token_hash, $expiring_date, $email);
        if ($stmt->execute()) {
            header('Content-Type: application/json');
            $response = send_password_reset($get_name, $get_email, $token_hash);
            echo $response;
        } else {
            http_response_code(400);
            echo json_encode([
                'status' => 400,
                'error' => true,
                'message' => 'Failed to update token in database',
            ], JSON_PRETTY_PRINT);
        }
    } else {
        http_response_code(404);
        echo json_encode([
            'status' => 404,
            'error' => true,
            'message' => 'User not found',
        ], JSON_PRETTY_PRINT);
    }
} else {
    http_response_code(400);
    echo json_encode([
        'status' => 400,
        'error' => true,
        'message' => 'Invalid request',
    ], JSON_PRETTY_PRINT);
}